/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.integration.ftbquests.tasks;

import com.strangeone101.pixeltweaks.integration.ftbquests.PokemonTaskTypes;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class DefeatPlayersTask
extends Task {
    public int count = 1;
    public String username = "";
    public String uuid = "";
    public transient UUID realUUID;

    public DefeatPlayersTask(long id, Quest q) {
        super(id, q);
    }

    public TaskType getType() {
        return PokemonTaskTypes.DEFEAT_PLAYER;
    }

    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putInt("count", this.count);
        if (!this.username.isEmpty()) {
            nbt.putString("username", this.username);
        }
        if (!this.uuid.isEmpty()) {
            nbt.putString("uuid", this.uuid);
        }
    }

    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.count = nbt.getInt("count");
        if (nbt.contains("username")) {
            this.username = nbt.getString("username");
        }
        if (nbt.contains("uuid")) {
            this.uuid = nbt.getString("uuid");
            if (!this.uuid.isEmpty()) {
                this.realUUID = UUID.fromString(this.uuid);
            }
        }
    }

    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeVarInt(this.count);
        buffer.writeUtf(this.username);
        buffer.writeUtf(this.uuid);
    }

    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.count = buffer.readVarInt();
        this.username = buffer.readUtf();
        this.uuid = buffer.readUtf();
        if (!this.uuid.isEmpty()) {
            this.realUUID = UUID.fromString(this.uuid);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addInt("count", this.count, v -> {
            this.count = v;
        }, 1, 1, Integer.MAX_VALUE);
        config.addString("username", this.username, v -> {
            this.username = v;
        }, "");
        config.addString("uuid", this.uuid, v -> {
            this.uuid = v;
            if (!this.uuid.isEmpty()) {
                this.realUUID = UUID.fromString(this.uuid);
            }
        }, "");
    }

    public void onDefeat(TeamData teamData, ServerPlayer defeated) {
        if (!teamData.isCompleted((QuestObject)this) && (this.username.isEmpty() || defeated.getGameProfile().getName().equals(this.username)) && (this.uuid.isEmpty() || defeated.getGameProfile().getId().equals(this.realUUID))) {
            teamData.addProgress((Task)this, 1L);
        }
    }
}

