/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.integration.ftbquests.tasks;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.pixelmon.battles.controller.participants.RaidPixelmonParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.strangeone101.pixeltweaks.integration.ftbquests.PokemonConfig;
import com.strangeone101.pixeltweaks.integration.ftbquests.PokemonTask;
import com.strangeone101.pixeltweaks.integration.ftbquests.PokemonTaskTypes;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class DefeatTask
extends PokemonTask {
    public Tristate wild = Tristate.DEFAULT;
    public transient PokemonSpecification cachedUsedSpec;
    public boolean invertUsed;

    public DefeatTask(long id, Quest q) {
        super(id, q);
    }

    public TaskType getType() {
        return PokemonTaskTypes.DEFEAT_POKEMON;
    }

    @Override
    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        this.wild.write(nbt, "wild");
        nbt.putString("usedPokemonSpec", this.cachedUsedSpec == null ? "" : this.cachedUsedSpec.toString());
        nbt.putBoolean("invertUsed", this.invertUsed);
    }

    @Override
    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.wild = Tristate.read((CompoundTag)nbt, (String)"wild");
        String usedPokemonSpec = nbt.getString("usedPokemonSpec");
        this.cachedUsedSpec = usedPokemonSpec.isEmpty() ? null : (PokemonSpecification)PokemonSpecificationProxy.create((String[])new String[]{usedPokemonSpec}).get();
        this.invertUsed = nbt.getBoolean("invertUsed");
    }

    @Override
    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        this.wild.write((FriendlyByteBuf)buffer);
        buffer.writeUtf(this.cachedUsedSpec == null ? "" : this.cachedUsedSpec.toString());
        buffer.writeBoolean(this.invertUsed);
    }

    @Override
    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.wild = Tristate.read((FriendlyByteBuf)buffer);
        String usedPokemonSpec = buffer.readUtf();
        this.cachedUsedSpec = usedPokemonSpec.isEmpty() ? null : (PokemonSpecification)PokemonSpecificationProxy.create((String[])new String[]{usedPokemonSpec}).get();
        this.invertUsed = buffer.readBoolean();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        if (this.cachedUsedSpec != null && this.cachedUsedSpec.getValue(SpeciesRequirement.class).isPresent()) {
            return Icon.getIcon((ResourceLocation)this.cachedUsedSpec.create().getSprite());
        }
        return super.getAltIcon();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Component getAltTitle() {
        if (this.cachedUsedSpec == null) {
            return super.getAltTitle();
        }
        MutableComponent pokemonDefeat = Component.literal((String)"");
        if (this.count > 1) {
            pokemonDefeat.append(this.count + "x ");
        }
        pokemonDefeat.append(this.getPokemon());
        Component usedPokemon = DefeatTask.getPokemon(this.cachedUsedSpec);
        return Component.translatable((String)("ftbquests.task." + this.getType().getTypeId().getNamespace() + "." + this.getType().getTypeId().getPath() + ".title.with"), (Object[])new Object[]{pokemonDefeat, usedPokemon});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addTristate("wild", this.wild, v -> {
            this.wild = v;
        }, Tristate.DEFAULT);
        config.add("usedPokemonSpec", (ConfigValue)new PokemonConfig(false), (Object)this.cachedUsedSpec, v -> {
            this.cachedUsedSpec = v;
        }, null);
        config.addBool("invertUsed", this.invertUsed, v -> {
            this.invertUsed = v;
        }, false);
    }

    public void defeatPokemon(TeamData team, PixelmonEntity pokemon, PixelmonEntity usedPokemon) {
        if (!(team.isCompleted((QuestObject)this) || this.cachedSpec != null && this.cachedSpec.matches((Object)pokemon) == this.invert || this.wild != Tristate.DEFAULT && (pokemon.getPixelmonWrapper().getParticipant() instanceof WildPixelmonParticipant || pokemon.getPixelmonWrapper().getParticipant() instanceof RaidPixelmonParticipant) != this.wild.get(true) || this.cachedUsedSpec != null && this.cachedUsedSpec.matches((Object)usedPokemon) == this.invertUsed)) {
            team.addProgress((Task)this, 1L);
        }
    }
}

