/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.integration.ftbquests.tasks;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.types.InteractEvolution;
import com.strangeone101.pixeltweaks.integration.ftbquests.PokemonTask;
import com.strangeone101.pixeltweaks.integration.ftbquests.PokemonTaskTypes;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EvolutionTask
extends PokemonTask {
    public EvolutionType evoType = EvolutionType.ANY;
    public ItemStack item = ItemStack.EMPTY;

    public EvolutionTask(long id, Quest q) {
        super(id, q);
    }

    public TaskType getType() {
        return PokemonTaskTypes.EVOLVE_POKEMON;
    }

    @Override
    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putByte("evolution_type", (byte)this.evoType.ordinal());
        if (this.evoType == EvolutionType.ITEM) {
            nbt.put("item", this.item.save(provider));
        }
    }

    @Override
    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.evoType = EvolutionType.values()[nbt.getByte("evolution_type")];
        if (this.evoType == EvolutionType.ITEM) {
            this.item = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt);
        }
    }

    @Override
    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeByte(this.evoType.ordinal());
        if (this.evoType == EvolutionType.ITEM) {
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)this.item);
        }
    }

    @Override
    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.evoType = EvolutionType.values()[buffer.readByte()];
        if (this.evoType == EvolutionType.ITEM) {
            this.item = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addEnum("evolution_type", (Object)this.evoType, v -> {
            this.evoType = v;
        }, NameMap.of((Object)((Object)EvolutionType.ANY), (Object[])EvolutionType.values()).nameKey(s -> "pixeltweaks.evolution_type." + s.toString().toLowerCase()).icon(type -> {
            String icon = "pixeltweaks:textures/gui/types/unknown.png";
            switch (type.ordinal()) {
                case 3: {
                    icon = "pixelmon:items/evolutionstones/firestone";
                    break;
                }
                case 2: {
                    icon = "pixelmon:items/linking_cord";
                    break;
                }
                case 1: {
                    icon = "pixelmon:items/healingitems/rarecandy";
                    break;
                }
                case 4: {
                    icon = "pixelmon:textures/items/healingitems/repel.png";
                }
            }
            return Icon.getIcon((ResourceLocation)ResourceLocation.parse((String)icon));
        }).create(), (Object)EvolutionType.ANY);
        config.addItemStack("item", this.item, v -> {
            this.item = v;
        }, ItemStack.EMPTY, true, true);
    }

    public void evolvePokemon(TeamData team, ServerPlayer player, Pokemon pokemon, Evolution evolution) {
        if (!team.isCompleted((QuestObject)this) && (this.cachedSpec == null || this.cachedSpec.matches((Object)pokemon) != this.invert) && this.matches(evolution)) {
            team.addProgress((Task)this, 1L);
        }
    }

    private boolean matches(Evolution evolution) {
        String evoType = evolution.evoType;
        if (this.evoType == EvolutionType.ANY || evoType == null) {
            return true;
        }
        switch (evoType) {
            case "leveling": {
                return this.evoType == EvolutionType.LEVELING;
            }
            case "trade": {
                return this.evoType == EvolutionType.TRADING;
            }
            case "interact": {
                return this.evoType == EvolutionType.ITEM && evolution instanceof InteractEvolution && (this.item.isEmpty() || ItemStack.matches((ItemStack)((InteractEvolution)evolution).item.getItemStack(), (ItemStack)this.item));
            }
            case "ticking": {
                return this.evoType == EvolutionType.TICKING;
            }
        }
        return false;
    }

    public static enum EvolutionType {
        ANY,
        LEVELING,
        TRADING,
        ITEM,
        TICKING;

    }
}

