/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.integration.ftbquests.tasks;

import com.pixelmonmod.pixelmon.api.pokedex.PlayerPokedex;
import com.pixelmonmod.pixelmon.api.pokedex.PokedexRegistrationStatus;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.type.Type;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.init.registry.PixelmonRegistry;
import com.strangeone101.pixeltweaks.integration.ftbquests.tasks.PokedexPercentageTask;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public abstract class PokedexTask
extends Task {
    protected int maxPokedexSize = PixelmonSpecies.getAll().size();
    protected transient Set<Integer> filteredPokedex = new HashSet<Integer>();
    public boolean caught = true;
    public PokedexFilter filter = PokedexFilter.ALL;
    public ResourceKey<Type> type = Type.NORMAL;
    public byte genMinFilter = 1;
    public byte genMaxFilter = (byte)9;
    public boolean allowUndexable = false;
    public int singleMon = 0;

    public PokedexTask(long id, Quest q) {
        super(id, q);
    }

    public long getMaxProgress() {
        return this.maxPokedexSize;
    }

    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putByte("filter", (byte)this.filter.ordinal());
        nbt.putBoolean("caught", this.caught);
        nbt.putBoolean("allowUndexable", this.allowUndexable);
        if (this.filter == PokedexFilter.TYPE) {
            nbt.putString("pokeType", this.type.location().toString());
        } else if (this.filter == PokedexFilter.GENERATION) {
            nbt.putByte("genMin", this.genMinFilter);
            nbt.putByte("genMax", this.genMaxFilter);
        } else if (this.filter == PokedexFilter.SINGLE_MON) {
            nbt.putInt("singleMon", this.singleMon);
        }
    }

    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.filter = PokedexFilter.values()[nbt.getByte("filter")];
        this.caught = nbt.getBoolean("caught");
        this.allowUndexable = nbt.getBoolean("allowUndexable");
        if (this.filter == PokedexFilter.TYPE) {
            this.type = Type.parseOrNull((String)nbt.getString("pokeType"));
        } else if (this.filter == PokedexFilter.GENERATION) {
            this.genMinFilter = nbt.getByte("genMin");
            this.genMaxFilter = nbt.getByte("genMax");
        } else if (this.filter == PokedexFilter.SINGLE_MON) {
            this.singleMon = nbt.getInt("singleMon");
        }
        this.calculateAmount();
    }

    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeByte(this.filter.ordinal());
        buffer.writeBoolean(this.caught);
        buffer.writeBoolean(this.allowUndexable);
        if (this.filter == PokedexFilter.TYPE) {
            buffer.writeUtf(this.type.location().toString());
        } else if (this.filter == PokedexFilter.GENERATION) {
            buffer.writeByte(this.genMinFilter);
            buffer.writeByte(this.genMaxFilter);
        } else if (this.filter == PokedexFilter.SINGLE_MON) {
            buffer.writeVarInt(this.singleMon);
        }
    }

    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.filter = PokedexFilter.values()[buffer.readByte()];
        this.caught = buffer.readBoolean();
        this.allowUndexable = buffer.readBoolean();
        if (this.filter == PokedexFilter.TYPE) {
            this.type = Type.parseOrNull((String)buffer.readUtf());
        } else if (this.filter == PokedexFilter.GENERATION) {
            this.genMinFilter = buffer.readByte();
            this.genMaxFilter = buffer.readByte();
        } else if (this.filter == PokedexFilter.SINGLE_MON) {
            this.singleMon = buffer.readVarInt();
        }
        this.calculateAmount();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        PokedexFilter[] filterTypes = PokedexFilter.values();
        if (this instanceof PokedexPercentageTask) {
            filterTypes = new PokedexFilter[]{PokedexFilter.ALL, PokedexFilter.GENERATION, PokedexFilter.TYPE, PokedexFilter.LEGEND, PokedexFilter.MYTHICAL, PokedexFilter.LEGEND_AND_MYTHICAL, PokedexFilter.ULTRA_BEAST};
        }
        config.addEnum("filter", (Object)this.filter, v -> {
            this.filter = v;
            this.calculateAmount();
        }, NameMap.of((Object)((Object)PokedexFilter.ALL), (Object[])filterTypes).nameKey(v -> "pixeltweaks.pokedex_filter_type." + v.name().toLowerCase()).create(), (Object)PokedexFilter.ALL);
        config.addBool("caught", this.caught, v -> {
            this.caught = v;
        }, true);
        config.addEnum("type", this.type, v -> {
            this.type = v;
            this.calculateAmount();
        }, NameMap.of((Object)Type.NORMAL, (Object[])((Registry)Minecraft.getInstance().level.registryAccess().registry(PixelmonRegistry.TYPE_REGISTRY).get()).registryKeySet().toArray(new ResourceKey[0])).nameKey(v -> "type." + v.location().getPath().toLowerCase()).icon(v -> Icon.getIcon((ResourceLocation)ResourceLocation.parse((String)("pixeltweaks:textures/gui/types/" + v.location().getPath().toLowerCase() + ".png")))).create(), (Object)Type.NORMAL);
        config.addInt("genMin", (int)this.genMinFilter, v -> {
            this.genMinFilter = v.byteValue();
            this.calculateAmount();
        }, 1, 1, 9);
        config.addInt("genMax", (int)this.genMaxFilter, v -> {
            this.genMaxFilter = v.byteValue();
            this.calculateAmount();
        }, 9, 1, 9);
        if (!(this instanceof PokedexPercentageTask)) {
            config.addInt("singleMon", this.singleMon, v -> {
                this.singleMon = v;
                this.filteredPokedex = new HashSet<Integer>();
                this.filteredPokedex.add(this.singleMon);
                this.maxPokedexSize = 1;
            }, 0, 1, 5000);
        }
        config.addBool("allowUndexable", this.allowUndexable, v -> {
            this.allowUndexable = v;
            this.calculateAmount();
        }, false);
    }

    protected void calculateAmount() {
        HashSet<Integer> all = new HashSet<Integer>();
        if (this.filter == PokedexFilter.SINGLE_MON) {
            all.add(this.singleMon);
            this.filteredPokedex = all;
            this.maxPokedexSize = all.size();
            return;
        }
        if (this.allowUndexable) {
            if (this.filter == PokedexFilter.TYPE) {
                PixelmonSpecies.getAll().parallelStream().forEach(species -> {
                    Stats form = species.getDefaultForm();
                    if (form.getTypes().contains(this.type)) {
                        all.add(species.getDex());
                    }
                });
            } else if (this.filter == PokedexFilter.GENERATION) {
                for (int current = this.genMinFilter; current <= this.genMaxFilter; ++current) {
                    all.addAll(PixelmonSpecies.getGenerationDex((int)current));
                }
            } else if (this.filter == PokedexFilter.LEGEND) {
                all.addAll(PixelmonSpecies.getLegendaries((boolean)true));
            } else if (this.filter == PokedexFilter.MYTHICAL) {
                all.addAll(PixelmonSpecies.getMythicals());
            } else if (this.filter == PokedexFilter.LEGEND_AND_MYTHICAL) {
                all.addAll(PixelmonSpecies.getLegendaries((boolean)false));
            } else if (this.filter == PokedexFilter.ULTRA_BEAST) {
                all.addAll(PixelmonSpecies.getUltraBeasts());
            } else {
                Iterator iterator = PixelmonSpecies.getGenerations().iterator();
                while (iterator.hasNext()) {
                    int gen = (Integer)iterator.next();
                    all.addAll(PixelmonSpecies.getGenerationDex((int)gen));
                }
            }
        } else {
            PixelmonSpecies.getAll().parallelStream().forEach(species -> {
                Stats form = species.getDefaultForm();
                if (form.hasTag(new String[]{"undexable"})) {
                    return;
                }
                if (this.filter == PokedexFilter.TYPE) {
                    if (form.getTypes().contains(this.type)) {
                        all.add(species.getDex());
                    }
                } else if (this.filter == PokedexFilter.GENERATION) {
                    if (species.getGeneration() >= this.genMinFilter && species.getGeneration() <= this.genMaxFilter) {
                        all.add(species.getDex());
                    }
                } else if (this.filter == PokedexFilter.LEGEND) {
                    if (form.getTags().isLegendary(true)) {
                        all.add(species.getDex());
                    }
                } else if (this.filter == PokedexFilter.MYTHICAL) {
                    if (form.getTags().isMythical()) {
                        all.add(species.getDex());
                    }
                } else if (this.filter == PokedexFilter.LEGEND_AND_MYTHICAL) {
                    if (form.getTags().isLegendary(false)) {
                        all.add(species.getDex());
                    }
                } else if (this.filter == PokedexFilter.ULTRA_BEAST) {
                    if (form.getTags().isUltraBeast()) {
                        all.add(species.getDex());
                    }
                } else {
                    all.add(species.getDex());
                }
            });
        }
        this.filteredPokedex = all;
        this.maxPokedexSize = all.size();
    }

    public void updatePokedex(TeamData teamData, ServerPlayer player) {
        if (teamData.isCompleted((QuestObject)this) || !teamData.getFile().isServerSide()) {
            return;
        }
        int ordinalToCheck = this.caught ? 2 : 1;
        try {
            PlayerPokedex dex = ((PlayerPartyStorage)StorageProxy.getParty((Player)player).get()).playerPokedex;
            int progress = (int)dex.getSeenMap().entrySet().parallelStream().filter(entry -> this.filteredPokedex.contains(entry.getKey()) && ((PokedexRegistrationStatus)entry.getValue()).ordinal() >= ordinalToCheck).count();
            progress += (int)dex.formDex.rowMap().entrySet().parallelStream().filter(entry -> this.filteredPokedex.contains(entry.getKey()) && ((Map)entry.getValue()).values().stream().anyMatch(e -> e >= ordinalToCheck)).count();
            progress = Math.min(progress, this.maxPokedexSize);
            teamData.setProgress((Task)this, (long)progress);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum PokedexFilter {
        ALL,
        GENERATION,
        TYPE,
        LEGEND,
        MYTHICAL,
        LEGEND_AND_MYTHICAL,
        ULTRA_BEAST,
        SINGLE_MON;

    }
}

