/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.integration.jei;

import com.strangeone101.pixeltweaks.integration.jei.JEIIntegration;
import com.strangeone101.pixeltweaks.integration.jei.PokemonIngredient;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;

public class PokemonIngredientHelper
implements IIngredientHelper<PokemonIngredient> {
    public IIngredientType<PokemonIngredient> getIngredientType() {
        return JEIIntegration.WRAPPED_POKEMON;
    }

    public String getDisplayName(PokemonIngredient ingredient) {
        Object species = I18n.get((String)ingredient.getForm().getParentSpecies().getTranslationKey(), (Object[])new Object[0]);
        String form = ingredient.getForm().getLocalizedName();
        if (!(form == null || form.isEmpty() || form.equals("Default") || form.equals("None"))) {
            species = form + " " + (String)species;
        }
        return species;
    }

    public String getUniqueId(PokemonIngredient ingredient, UidContext context) {
        return this.getResourceId(ingredient);
    }

    public String getDisplayModId(PokemonIngredient ingredient) {
        return "pixelmon";
    }

    public ResourceLocation getResourceLocation(PokemonIngredient pokemonIngredient) {
        return ResourceLocation.fromNamespaceAndPath((String)"pixelmon", (String)this.getResourceId(pokemonIngredient));
    }

    public String getResourceId(PokemonIngredient ingredient) {
        Object species = ingredient.getForm().getParentSpecies().getName();
        String form = ingredient.getForm().getName();
        if (form != null && !form.isEmpty()) {
            species = form + "_" + (String)species;
        }
        return species;
    }

    public PokemonIngredient copyIngredient(PokemonIngredient ingredient) {
        return ingredient;
    }

    public boolean isValidIngredient(PokemonIngredient ingredient) {
        return true;
    }

    public String getErrorInfo(@Nullable PokemonIngredient ingredient) {
        return this.getResourceId(ingredient);
    }
}

