/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.mixin;

import com.pixelmonmod.pixelmon.api.battles.BattleItemScanner;
import com.pixelmonmod.pixelmon.battles.controller.Experience;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.init.registry.ItemRegistration;
import com.pixelmonmod.pixelmon.items.HeldItem;
import com.pixelmonmod.pixelmon.items.helpers.ItemHelper;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.launch.MixinInitialisationError;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Experience.class})
public class ExperienceMixin {
    @Unique
    private static ItemStack pixelTweaks$EXP_ALL_ACTIVE;

    @Overwrite(remap=false)
    public static void awardExp(List<BattleParticipant> participants, BattleParticipant losingTeamOwner, PixelmonWrapper faintedPokemon) {
        if (faintedPokemon == null || faintedPokemon.bc.isRaid() || faintedPokemon.bc.isLevelingDisabled()) {
            return;
        }
        for (BattleParticipant teamOwner : participants) {
            if (teamOwner.team == losingTeamOwner.team || !(teamOwner instanceof PlayerParticipant)) continue;
            PlayerParticipant player = (PlayerParticipant)teamOwner;
            List attackers = faintedPokemon.getOpponentPokemon();
            for (PixelmonWrapper pw : attackers) {
                if (pw.getParticipant() != teamOwner) continue;
                ExperienceMixin.calcExp(faintedPokemon, pw, 1.0);
            }
            ItemStack expAllFound = BattleItemScanner.findMatchingItem((ItemStack)ExperienceMixin.pixelTweaks$getExpAllActive(), (ServerPlayer)player.player);
            boolean hasExpAll = expAllFound != null;
            for (PixelmonWrapper pw : teamOwner.allPokemon) {
                if (attackers.contains(pw) || !hasExpAll && (pw.getHeldItem().getItem() instanceof AirItem || ((HeldItem)pw.getHeldItem().getItem()).getHeldItemType() != EnumHeldItems.expShare)) continue;
                ExperienceMixin.calcExp(faintedPokemon, pw, 0.5);
            }
            player.givePlayerExperience(faintedPokemon);
        }
    }

    @Shadow(remap=false)
    private static void calcExp(PixelmonWrapper faintedPokemon, PixelmonWrapper expReceiver, double scaleFactor) {
        throw new MixinInitialisationError("Mixin failed to shadow calcExp");
    }

    @Unique
    private static ItemStack pixelTweaks$getExpAllActive() {
        if (pixelTweaks$EXP_ALL_ACTIVE == null) {
            pixelTweaks$EXP_ALL_ACTIVE = new ItemStack((Holder)ItemRegistration.EXP_ALL);
            CompoundTag tag = new CompoundTag();
            tag.putBoolean("Activated", true);
            ItemHelper.setTag((ItemStack)pixelTweaks$EXP_ALL_ACTIVE, (CompoundTag)tag);
        }
        return pixelTweaks$EXP_ALL_ACTIVE;
    }
}

