/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.mixin.block;

import com.pixelmonmod.pixelmon.blocks.ApricornLeavesBlock;
import com.pixelmonmod.pixelmon.blocks.BerryLeavesBlock;
import com.pixelmonmod.pixelmon.enums.items.ApricornType;
import com.strangeone101.pixeltweaks.TweaksConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.CommonHooks;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ApricornLeavesBlock.class})
public class ApriconLeavesBlockMixin
extends LeavesBlock {
    @Final
    @Shadow(remap=false)
    private ApricornType apricorn;

    public ApriconLeavesBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Overwrite
    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)PERSISTENT)).booleanValue()) {
            super.randomTick(state, level, pos, rand);
        } else {
            int i = (Integer)state.getValue((Property)BerryLeavesBlock.AGE);
            if (i < 2 && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (rand.nextInt(this.apricorn.getGrowthTime()) == 0 ? 1 : 0) != 0)) {
                state = (BlockState)state.setValue((Property)BerryLeavesBlock.AGE, (Comparable)Integer.valueOf(i + 1));
                level.setBlock(pos, state, 2);
                CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
            }
            super.randomTick(state, level, pos, rand);
        }
        if (((Boolean)state.getValue((Property)PERSISTENT)).booleanValue()) {
            super.randomTick(state, level, pos, rand);
        } else if (((Boolean)TweaksConfig.randomlyDropRipeApricorns.get()).booleanValue() && rand.nextInt(this.apricorn.getGrowthTime() * 20) == 0) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BerryLeavesBlock.AGE, (Comparable)Integer.valueOf(0)), 2);
            ItemStack stack = new ItemStack((ItemLike)this.apricorn.apricorn());
            ArrayList<Direction> directions = new ArrayList<Direction>(Arrays.asList(Direction.values()));
            Collections.shuffle(directions);
            for (Direction dir : directions) {
                BlockPos offset = pos.offset(dir.getNormal());
                if (level.getBlockState(offset).isSolid()) continue;
                ItemEntity item = new ItemEntity((Level)level, (double)pos.getX() + 0.5 + (double)dir.getStepX() * 0.5, (double)pos.getY() + 0.5 + (double)dir.getStepY() * 0.5, (double)pos.getZ() + 0.5 + (double)dir.getStepZ() * 0.5, stack);
                item.lifespan = 1200;
                level.addFreshEntity((Entity)item);
                return;
            }
        }
        super.randomTick(state, level, pos, rand);
    }
}

