/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.mixin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenParticleEngine;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays.OpponentElement;
import com.pixelmonmod.pixelmon.client.gui.widgets.PixelmonWidget;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import java.awt.Color;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={OpponentElement.class})
public abstract class OpponentElementMixin
extends PixelmonWidget {
    @Shadow(remap=false)
    private static ResourceLocation OPPONENT;
    @Shadow(remap=false)
    private static ResourceLocation HEALTHY;
    @Shadow(remap=false)
    private static ResourceLocation CAUTION;
    @Shadow(remap=false)
    private static ResourceLocation WARNING;
    @Shadow(remap=false)
    private static ResourceLocation SHINY;
    @Shadow(remap=false)
    private static ResourceLocation CAUGHT;
    @Shadow(remap=false)
    private static ResourceLocation TARGET;
    @Shadow(remap=false)
    private Screen parent;
    @Shadow(remap=false)
    private PixelmonClientData enemy;
    @Shadow(remap=false)
    private ScreenParticleEngine particleEngine;

    public void drawElement(GuiGraphics graphics, float scale) {
        boolean shiny;
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        ScreenHelper.drawImage((GuiGraphics)graphics, (ResourceLocation)OPPONENT, (float)this.x, (float)(this.y - 3), (float)160.0f, (float)50.0f, (float)this.zLevel);
        float healthPercent = this.enemy.health.floatValue() / (float)this.enemy.maxHealth;
        ScreenHelper.drawBar((GuiGraphics)graphics, (double)(this.x + 44), (double)(this.y + 20), (double)109.0, (double)10.0, (float)healthPercent, (Color)PixelmonClientData.getHealthColor((double)this.enemy.health.intValue(), (int)this.enemy.maxHealth));
        ScreenHelper.drawImage((ResourceLocation)(healthPercent <= 0.5f ? (healthPercent <= 0.25f ? WARNING : CAUTION) : HEALTHY), (GuiGraphics)graphics, (float)(this.x - 10), (float)(this.y - 18), (float)60.0f, (float)60.0f, (float)this.zLevel);
        float[] rgb = new float[]{1.0f, 1.0f, 1.0f};
        boolean boss = this.enemy.bossTier.isBoss();
        boolean bl = shiny = this.enemy.palette.equalsIgnoreCase("shiny") && !boss;
        if (boss) {
            rgb = this.enemy.bossTier.getColor().getColorComponents(null);
        }
        ResourceLocation texture = ScreenHelper.getPokemonSprite((PixelmonClientData)this.enemy, (Minecraft)this.parent.getMinecraft());
        Minecraft.getInstance().getTextureManager().bindForSetup(texture == null ? TextureManager.INTENTIONAL_MISSING_TEXTURE : texture);
        PoseStack matrix = graphics.pose();
        matrix.pushPose();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        graphics.setColor(rgb[0], rgb[1], rgb[2], 1.0f);
        int ix = this.x + 1;
        int iy = this.y - 4;
        matrix.translate((double)((float)this.x - (float)ix), (double)((float)this.y - (float)iy), (double)this.zLevel);
        graphics.blit(texture, ix, iy, 0.0f, 0.0f, 40, 40, 40, 40);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        matrix.popPose();
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.particleEngine.drawAtOffset(graphics, this.enemy.pokemonUUID.toString(), (double)(this.x + 5), (double)(this.y + 1), (double)RandomHelper.getRandom().nextInt(26), (double)RandomHelper.getRandom().nextInt(26));
        float offset = 0.0f;
        if (ClientStorageManager.pokedex().hasCaught(this.enemy.species)) {
            ScreenHelper.drawImage((GuiGraphics)graphics, (ResourceLocation)CAUGHT, (float)(this.x + 52), (float)(this.y + 5), (float)8.0f, (float)8.0f, (float)this.zLevel);
            offset += 9.0f;
        }
        if (this.enemy.getGender() != Gender.NONE) {
            ScreenHelper.drawImage((ResourceLocation)(this.enemy.getGender() == Gender.MALE ? Resources.male : Resources.female), (GuiGraphics)graphics, (float)((float)(this.x + 52) + offset), (float)(this.y + 5), (float)5.0f, (float)8.0f, (float)this.zLevel);
            offset += 7.0f;
        }
        int labelColor = boss ? 16743541 : (shiny ? -7545 : -986896);
        ScreenHelper.drawScaledString((GuiGraphics)graphics, (Component)this.enemy.getDisplayName(), (float)((float)(this.x + 52) + offset), (float)((float)this.y + 5.75f), (int)labelColor, (float)16.0f);
        ScreenHelper.drawScaledStringRightAligned((GuiGraphics)graphics, (String)("Lv." + this.enemy.level), (float)(this.x + 149), (float)((float)this.y + 7.0f), (int)-986896, (boolean)false, (float)12.0f);
        if (PixelmonConfigProxy.getGraphics().isAdvancedBattleInformation()) {
            DecimalFormat df = new DecimalFormat(".#");
            String percentage = df.format((double)healthPercent * 100.0).replace(".0", "");
            if (percentage.isEmpty()) {
                percentage = "0";
            }
            ScreenHelper.drawScaledStringRightAligned((GuiGraphics)graphics, (String)(percentage + "%"), (float)(this.x + 145), (float)((float)this.y + 22.0f), (int)-986896, (boolean)false, (float)14.0f);
        }
        if (this.enemy.status != -1 && StatusType.getEffect((int)this.enemy.status) != null) {
            float[] texturePair2 = StatusType.getTexturePos((StatusType)StatusType.getEffect((int)this.enemy.status));
            ScreenHelper.simpleDrawImageQuad((ResourceLocation)Resources.status, (GuiGraphics)graphics, (float)((float)(this.x + 54 + ScreenHelper.getStringWidth((Component)this.enemy.getDisplayName())) + offset), (float)(this.y + 4), (float)10.5f, (float)10.5f, (float)(texturePair2[0] / 768.0f), (float)(texturePair2[1] / 768.0f), (float)((texturePair2[0] + 240.0f) / 768.0f), (float)((texturePair2[1] + 240.0f) / 768.0f), (float)this.zLevel);
        }
        if (ClientProxy.battleManager.catchCombo != 0) {
            ScreenHelper.drawScaledString((GuiGraphics)graphics, (String)I18n.get((String)"gui.battle.catch_combo", (Object[])new Object[]{ClientProxy.battleManager.catchCombo}), (float)((float)(this.x + 22) + offset), (float)((float)this.y + 38.75f), (int)-986896, (float)12.0f);
        }
        if (shiny && RandomHelper.getRandom().nextInt(80) == 0) {
            int size = 7 + RandomHelper.getRandom().nextInt(7);
            this.particleEngine.addParticle(new ScreenParticleEngine.GuiParticle(this.enemy.pokemonUUID.toString(), SHINY, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0f, 0.8f, 0.3f, 0.0f, (float)size, (float)size, 120, (particle, matrixStack) -> {
                int x = particle.age;
                int m = particle.maxAge;
                int h = m / 2;
                particle.a = (float)(x <= h ? x : h - (x - h)) / (float)h;
            }));
        }
    }
}

