/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.music;

import com.pixelmonmod.pixelmon.client.music.PixelmonMusic;
import com.strangeone101.pixeltweaks.PixelTweaks;
import com.strangeone101.pixeltweaks.music.Music;
import com.strangeone101.pixeltweaks.music.TrackableSound;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundSource;

public class ChainedMusic {
    private final Music music;
    private TrackableSound intro;
    private TrackableSound loop;
    private TrackableSound end;
    private boolean finished = false;

    public ChainedMusic(Music music) {
        this.music = music;
        if (music.start != null) {
            this.intro = new TrackableSound(music.start, SoundSource.MUSIC, music.volume, music.pitch, false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true);
        }
        if (music.loop != null) {
            this.loop = new TrackableSound(music.loop, SoundSource.MUSIC, music.volume, music.pitch, true, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true);
        }
        if (music.end != null) {
            this.end = new TrackableSound(music.end, SoundSource.MUSIC, music.volume, music.pitch, false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true);
        }
        this.tick();
    }

    public void tick() {
        if (this.intro != null && !this.intro.isStarted()) {
            if (this.music.fade.start > 0L) {
                this.intro.fadeIn(this.music.fade.start);
            } else {
                this.intro.play();
            }
        } else if ((this.intro == null || this.intro.isFinished()) && this.loop != null && !this.loop.isStarted()) {
            this.loop.play();
        }
    }

    public boolean shouldTick() {
        return this.intro != null && !this.finished;
    }

    public void finish(Runnable callback) {
        if (this.finished) {
            return;
        }
        this.finished = true;
        PixelTweaks.LOGGER.debug("Ending music...");
        if (this.intro != null && this.intro.isPlaying()) {
            long time = this.end == null ? this.music.fade.end : 1000L;
            this.intro.fadeOut(time);
            PixelmonMusic.EXECUTOR.schedule(callback, time, TimeUnit.MILLISECONDS);
            PixelTweaks.LOGGER.debug("Intro fading out");
        }
        if (this.loop != null && this.loop.isPlaying()) {
            this.loop.fadeOut(this.end == null ? this.music.fade.end : 1000L);
            PixelTweaks.LOGGER.debug("Loop fading out");
            if (this.end == null) {
                PixelmonMusic.EXECUTOR.schedule(callback, 1000L, TimeUnit.MILLISECONDS);
            }
        }
        if (this.end != null && !this.end.isFinished()) {
            this.end.fadeOut(1000L);
            PixelTweaks.LOGGER.debug("End fading out");
            PixelmonMusic.EXECUTOR.submit(() -> {
                try {
                    Thread.sleep(20L);
                    while (true) {
                        if (!this.isPlaying()) {
                            callback.run();
                            return;
                        }
                        Thread.sleep(20L);
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public boolean isPlaying() {
        if (this.intro != null && this.intro.isPlaying()) {
            return true;
        }
        if (this.loop != null && this.loop.isPlaying()) {
            return true;
        }
        return this.end != null && this.end.isPlaying();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChainedMusic music1 = (ChainedMusic)o;
        return this.finished == music1.finished && Objects.equals(this.music, music1.music) && Objects.equals(this.intro, music1.intro) && Objects.equals(this.loop, music1.loop) && Objects.equals(this.end, music1.end);
    }

    public int hashCode() {
        return Objects.hash(this.music, this.intro, this.loop, this.end, this.finished);
    }

    public TrackableSound getPlaying() {
        if (this.intro != null && this.intro.isPlaying()) {
            return this.intro;
        }
        if (this.loop != null && this.loop.isPlaying()) {
            return this.loop;
        }
        if (this.end != null && this.end.isPlaying()) {
            return this.end;
        }
        return null;
    }
}

