/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.music;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.strangeone101.pixeltweaks.struct.Fade;
import java.lang.reflect.Type;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;

public class Sound {
    public ResourceLocation sound;
    public Fade fade = new Fade(0L, 0L);
    public float volume = 1.0f;
    public float pitch = 1.0f;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sound sound1 = (Sound)o;
        return Float.compare(sound1.volume, this.volume) == 0 && Float.compare(sound1.pitch, this.pitch) == 0 && Objects.equals(this.sound, sound1.sound) && Objects.equals(this.fade, sound1.fade);
    }

    public int hashCode() {
        return Objects.hash(this.sound, this.fade, Float.valueOf(this.volume), Float.valueOf(this.pitch));
    }

    public String toString() {
        return "Sound[" + this.sound.toString() + "]";
    }

    public static class Deserializer
    implements JsonDeserializer<Sound> {
        public Sound deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
                Sound sound = new Sound();
                sound.sound = (ResourceLocation)context.deserialize(json, ResourceLocation.class);
                return sound;
            }
            if (json.isJsonObject()) {
                Sound sound = new Sound();
                JsonObject o = json.getAsJsonObject();
                if (o.has("fade")) {
                    sound.fade = (Fade)context.deserialize(o.get("fade"), Fade.class);
                }
                if (o.has("volume")) {
                    sound.volume = o.get("volume").getAsFloat();
                }
                if (o.has("pitch")) {
                    sound.pitch = o.get("pitch").getAsFloat();
                }
                if (o.has("sound")) {
                    sound.sound = (ResourceLocation)context.deserialize(o.get("sound"), ResourceLocation.class);
                }
                return sound;
            }
            return null;
        }
    }
}

