/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.music;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.pixelmonmod.pixelmon.client.music.PixelmonMusic;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.strangeone101.pixeltweaks.PixelTweaks;
import com.strangeone101.pixeltweaks.music.ChainedMusic;
import com.strangeone101.pixeltweaks.music.MusicEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;

public class SoundManager {
    public static final ExecutorService EXECUTOR;
    public static Set<ChainedMusic> ALL_MUSIC;
    public static Set<ChainedMusic> BATTLE_MUSIC;

    public static void fadeSoundToStart(SoundInstance sound, long millis) {
        try {
            PixelTweaks.LOGGER.debug("fadeSoundToStart " + String.valueOf(sound.getSound().getLocation()));
            if (PixelmonMusic.getSoundHandler().isActive(sound)) {
                return;
            }
            EXECUTOR.submit(() -> {
                PixelTweaks.LOGGER.debug("Fading sound to start executor: " + String.valueOf(sound.getSound().getLocation()));
                PixelmonMusic.resetFade((SoundInstance)sound, (boolean)false);
                PixelmonMusic.getSoundHandler().play(sound);
                AtomicReference channel = new AtomicReference();
                PixelmonMusic.getSoundHandler().soundEngine.instanceToChannel.forEach((s, c) -> {
                    if (Objects.equals(sound, s)) {
                        channel.set(c);
                    }
                });
                float initialVolume = channel.get() != null ? PixelmonMusic.getSoundHandler().soundEngine.calculateVolume(sound) : 1.0f;
                try {
                    int i = 0;
                    while ((long)i < millis) {
                        float volume = PixelmonMusic.fadeSound((SoundInstance)sound, (float)initialVolume, (long)millis, (boolean)false);
                        if (channel.get() != null) {
                            ((ChannelAccess.ChannelHandle)channel.get()).execute(source -> source.setVolume(volume));
                        }
                        Thread.sleep(1L);
                        ++i;
                    }
                }
                catch (InterruptedException var7) {
                    var7.printStackTrace();
                }
                PixelmonMusic.resetFade((SoundInstance)sound, (boolean)false);
                if (channel.get() != null) {
                    ((ChannelAccess.ChannelHandle)channel.get()).execute(source -> source.setVolume(initialVolume));
                }
            });
        }
        catch (Exception var4) {
            PixelmonMusic.getSoundHandler().play(sound);
        }
    }

    public static void fadeSoundToStop(SimpleSoundInstance sound, long millis, Runnable runnable) {
        block3: {
            try {
                if (!PixelmonMusic.getSoundHandler().isActive((SoundInstance)sound)) {
                    return;
                }
                EXECUTOR.submit(() -> {
                    PixelTweaks.LOGGER.debug("Fading sound to stop: " + String.valueOf(sound.getSound().getLocation()));
                    PixelmonMusic.resetFade((SoundInstance)sound, (boolean)true);
                    AtomicReference<Object> channel = new AtomicReference<Object>(null);
                    PixelmonMusic.getSoundHandler().soundEngine.instanceToChannel.forEach((s, c) -> {
                        if (Objects.equals(sound, s)) {
                            channel.set(c);
                        }
                    });
                    float initialVolume = channel.get() != null ? PixelmonMusic.getSoundHandler().soundEngine.calculateVolume((SoundInstance)sound) : 1.0f;
                    try {
                        int i = 0;
                        while ((long)i < millis) {
                            float volume = PixelmonMusic.fadeSound((SoundInstance)sound, (float)initialVolume, (long)millis, (boolean)true);
                            if (channel.get() != null) {
                                ((ChannelAccess.ChannelHandle)channel.get()).execute(source -> source.setVolume(volume));
                            }
                            Thread.sleep(1L);
                            ++i;
                        }
                    }
                    catch (InterruptedException var8) {
                        var8.printStackTrace();
                    }
                    PixelmonMusic.getSoundHandler().stop((SoundInstance)sound);
                    PixelmonMusic.resetFade((SoundInstance)sound, (boolean)true);
                    if (channel.get() != null) {
                        ((ChannelAccess.ChannelHandle)channel.get()).execute(source -> source.setVolume(initialVolume));
                    }
                    if (runnable != null) {
                        runnable.run();
                    }
                });
            }
            catch (Exception var5) {
                PixelmonMusic.getSoundHandler().stop((SoundInstance)sound);
                if (runnable == null) break block3;
                runnable.run();
            }
        }
    }

    public static void playBattleAction(PixelmonEntity entity, MusicEvent.BattleAction.Action ... actions) {
        for (MusicEvent.BattleAction.Action action : actions) {
            Collection events = MusicEvent.BattleAction.REGISTRY.getOrDefault((Object)action, new HashSet());
            PixelTweaks.LOGGER.debug("Size of battle action events for " + String.valueOf((Object)action) + ": " + events.size());
            Optional<MusicEvent.BattleAction> optional = events.stream().filter(event -> event.conditions.stream().allMatch(condition -> {
                if (condition.conditionMet(entity)) {
                    PixelTweaks.LOGGER.debug("Condition " + condition.toString() + " met!");
                    return true;
                }
                PixelTweaks.LOGGER.debug("Condition " + condition.toString() + " failed!");
                return false;
            })).findFirst();
            if (!optional.isPresent()) continue;
            MusicEvent.BattleAction event2 = optional.get();
            PixelTweaks.LOGGER.debug("Playing sound event for battle action " + event2.action.toString());
            SoundManager.playEvent(event2);
            return;
        }
    }

    public static void playEvent(MusicEvent event) {
        if (event.music != null) {
            ChainedMusic chainedMusic = new ChainedMusic(event.music);
            Set<ChainedMusic> allMusic = ALL_MUSIC;
            if (event instanceof MusicEvent.Battle) {
                allMusic = BATTLE_MUSIC;
            }
            if (event.music.cutOtherMusic) {
                for (ChainedMusic music : allMusic) {
                    music.finish(() -> {});
                }
                allMusic.clear();
            }
            ALL_MUSIC.add(chainedMusic);
            if (event instanceof MusicEvent.Battle) {
                BATTLE_MUSIC.add(chainedMusic);
            }
            PixelTweaks.LOGGER.debug("Playing music " + event.getFile());
        } else if (event.sound != null) {
            SimpleSoundInstance sound = new SimpleSoundInstance(event.sound.sound, SoundSource.BLOCKS, event.sound.volume, event.sound.pitch, RandomSource.create(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true);
            SoundManager.fadeSoundToStart((SoundInstance)sound, event.sound.fade.start);
            PixelTweaks.LOGGER.debug("Playing sound " + event.getFile());
        }
    }

    public static void pauseAllMusic() {
        PixelTweaks.LOGGER.debug("Pausing all music");
        List pixelTweaksMusic = ALL_MUSIC.stream().map(ChainedMusic::getPlaying).collect(Collectors.toList());
        PixelmonMusic.getSoundHandler().soundEngine.instanceToChannel.forEach((s, e) -> {
            if (s.getSource() == SoundSource.MUSIC && e.channel != null && !pixelTweaksMusic.contains(s)) {
                e.channel.pause();
            }
        });
    }

    public static void resumeAllMusic() {
        PixelTweaks.LOGGER.debug("Resuming all music");
        List pixelTweaksMusic = ALL_MUSIC.stream().map(ChainedMusic::getPlaying).collect(Collectors.toList());
        PixelmonMusic.getSoundHandler().soundEngine.instanceToChannel.forEach((s, e) -> {
            if (s.getSource() == SoundSource.MUSIC && e.channel != null && !pixelTweaksMusic.contains(s)) {
                SoundManager.fadeSoundToStart(s, 2000L);
            }
        });
    }

    static {
        ALL_MUSIC = new HashSet<ChainedMusic>();
        BATTLE_MUSIC = new HashSet<ChainedMusic>();
        PixelTweaks.LOGGER.debug("Starting music thread");
        EXECUTOR = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setPriority(5).setDaemon(true).setNameFormat("pixeltweaks_sound_%d").build());
        EXECUTOR.submit(() -> {
            try {
                Thread.sleep(20L);
                while (Minecraft.getInstance().isRunning()) {
                    Iterator<ChainedMusic> allMusic = ALL_MUSIC.iterator();
                    while (allMusic.hasNext()) {
                        ChainedMusic music = allMusic.next();
                        if (music.shouldTick()) {
                            music.tick();
                            continue;
                        }
                        if (music.isPlaying()) continue;
                        allMusic.remove();
                        BATTLE_MUSIC.remove(music);
                    }
                    Thread.sleep(20L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

