/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.pixelevents;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.strangeone101.pixeltweaks.pixelevents.condition.BiomeCondition;
import com.strangeone101.pixeltweaks.pixelevents.condition.CalendarCondition;
import com.strangeone101.pixeltweaks.pixelevents.condition.ChanceCondition;
import com.strangeone101.pixeltweaks.pixelevents.condition.DimensionCondition;
import com.strangeone101.pixeltweaks.pixelevents.condition.IsRaidCondition;
import com.strangeone101.pixeltweaks.pixelevents.condition.PlayerCondition;
import com.strangeone101.pixeltweaks.pixelevents.condition.PokemonCondition;
import com.strangeone101.pixeltweaks.pixelevents.condition.PokemonListCondition;
import com.strangeone101.pixeltweaks.pixelevents.condition.StructureCondition;
import com.strangeone101.pixeltweaks.pixelevents.condition.TimeCondition;
import com.strangeone101.pixeltweaks.pixelevents.condition.WeatherCondition;
import java.lang.reflect.Type;

public abstract class Condition<T> {
    public String type;

    protected abstract boolean conditionMet(T var1);

    public abstract T itemFromPixelmon(PixelmonEntity var1);

    public boolean conditionMet(PixelmonEntity entity) {
        return this.conditionMet(this.itemFromPixelmon(entity));
    }

    public String toString() {
        return "Condition{type='" + this.type + "'}";
    }

    public static class Deserializer
    implements JsonDeserializer<Condition<?>> {
        public Condition<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            String conditionType = jsonObject.get("type").getAsString();
            if ("pokemon".equals(conditionType)) {
                return (Condition)context.deserialize(json, PokemonCondition.class);
            }
            if ("pokemon_list".equals(conditionType)) {
                return (Condition)context.deserialize(json, PokemonListCondition.class);
            }
            if ("biome".equals(conditionType)) {
                return (Condition)context.deserialize(json, BiomeCondition.class);
            }
            if ("structure".equals(conditionType)) {
                return (Condition)context.deserialize(json, StructureCondition.class);
            }
            if ("player".equals(conditionType)) {
                return (Condition)context.deserialize(json, PlayerCondition.class);
            }
            if ("weather".equals(conditionType)) {
                return (Condition)context.deserialize(json, WeatherCondition.class);
            }
            if ("time".equals(conditionType)) {
                return (Condition)context.deserialize(json, TimeCondition.class);
            }
            if ("dimension".equals(conditionType)) {
                return (Condition)context.deserialize(json, DimensionCondition.class);
            }
            if ("calendar".equals(conditionType)) {
                return (Condition)context.deserialize(json, CalendarCondition.class);
            }
            if ("chance".equals(conditionType)) {
                return (Condition)context.deserialize(json, ChanceCondition.class);
            }
            if ("is_raid".equals(conditionType)) {
                return (Condition)context.deserialize(json, IsRaidCondition.class);
            }
            throw new JsonParseException("Invalid condition type: " + conditionType);
        }
    }
}

