/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.pixelevents;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.strangeone101.pixeltweaks.client.overlay.PokemonOverlay;
import com.strangeone101.pixeltweaks.music.MusicEvent;
import com.strangeone101.pixeltweaks.pixelevents.Condition;
import com.strangeone101.pixeltweaks.pixelevents.IValidator;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class Event {
    public String type;
    public List<Condition> conditions = new ArrayList<Condition>();
    public int priority = 0;
    transient String pack;
    transient String file;

    public String getPack() {
        return this.pack;
    }

    public String getFile() {
        return this.file;
    }

    public int getPriority() {
        return this.priority;
    }

    public abstract boolean isClientSide();

    public String toString() {
        return "Event{type='" + this.type + "', conditions=" + String.valueOf(this.conditions) + ", pack='" + this.pack + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        return this.priority == event.priority && Objects.equals(this.type, event.type) && Objects.equals(this.conditions, event.conditions) && Objects.equals(this.pack, event.pack) && Objects.equals(this.file, event.file);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.conditions, this.priority, this.pack, this.file);
    }

    public static class Deserializer
    implements JsonDeserializer<Event> {
        public Event deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            String eventType = jsonObject.get("type").getAsString();
            if (jsonObject.has("pack")) {
                jsonObject.remove("pack");
            }
            Event event = null;
            if ("bgm".equals(eventType)) {
                event = (Event)context.deserialize(json, MusicEvent.BGM.class);
            } else if ("battle_music".equals(eventType) || "battlemusic".equals(eventType)) {
                event = (Event)context.deserialize(json, MusicEvent.Battle.class);
            } else if ("pokemon_overlay".equals(eventType)) {
                event = (Event)context.deserialize(json, PokemonOverlay.class);
            } else if ("battle_action".equals(eventType)) {
                event = (Event)context.deserialize(json, MusicEvent.BattleAction.class);
            } else {
                throw new JsonParseException("Invalid event type: " + eventType);
            }
            if (event instanceof IValidator && !((IValidator)((Object)event)).validate()) {
                throw new JsonParseException("Failed to validate " + eventType + ": " + ((IValidator)((Object)event)).getError());
            }
            return event;
        }
    }
}

