/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.pixelevents;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.strangeone101.pixeltweaks.PixelTweaks;
import com.strangeone101.pixeltweaks.client.overlay.OverlayLayer;
import com.strangeone101.pixeltweaks.music.Sound;
import com.strangeone101.pixeltweaks.pixelevents.Condition;
import com.strangeone101.pixeltweaks.pixelevents.Event;
import com.strangeone101.pixeltweaks.pixelevents.EventListener;
import com.strangeone101.pixeltweaks.struct.SpecificTime;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;

public class EventRegistry
implements PreparableReloadListener {
    private static Map<Class<? extends Event>, Set<Event>> EVENTS = Maps.newHashMap();

    protected static void registerEvent(Event event) {
        EVENTS.computeIfAbsent(event.getClass(), k -> EventRegistry.newTreeset()).add(event);
        if (event instanceof EventListener) {
            ((EventListener)((Object)event)).onRegister();
        }
    }

    public static TreeSet<Event> newTreeset() {
        return Sets.newTreeSet((e1, e2) -> {
            if (e1.getPriority() == e2.getPriority()) {
                return e2.hashCode() - e1.hashCode();
            }
            return e2.getPriority() - e1.getPriority();
        });
    }

    public static <T extends Event> Collection<T> getEvents(Class<T> eventClass) {
        return EVENTS.getOrDefault(eventClass, Sets.newHashSet());
    }

    public EventRegistry() {
        if (Minecraft.getInstance().getResourceManager() instanceof ReloadableResourceManager) {
            PixelTweaks.LOGGER.debug("Added music loader");
            ((ReloadableResourceManager)Minecraft.getInstance().getResourceManager()).registerReloadListener((PreparableReloadListener)this);
        } else {
            PixelTweaks.LOGGER.debug("Failed to add music loader");
        }
    }

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller profilerFiller, ProfilerFiller profilerFiller1, Executor executor, Executor executor1) {
        return CompletableFuture.supplyAsync(() -> {
            String directoryPath = "pixelevents";
            PixelTweaks.LOGGER.debug("Loading events from " + directoryPath);
            Map fileLocations = resourceManager.listResources(directoryPath, file -> file.toDebugFileName().toLowerCase().endsWith(".json"));
            Gson gson = new GsonBuilder().registerTypeAdapter(Event.class, (Object)new Event.Deserializer()).registerTypeAdapter(Condition.class, (Object)new Condition.Deserializer()).registerTypeAdapter(ResourceLocation.class, (json, type, context) -> json.isJsonNull() || json.getAsString().isEmpty() ? null : ResourceLocation.parse((String)json.getAsString())).registerTypeAdapter(PokemonSpecification.class, (json, type, context) -> (PokemonSpecification)PokemonSpecificationProxy.create((String[])new String[]{json.getAsString()}).get()).registerTypeAdapter(SpecificTime.class, (Object)new SpecificTime.Deserializer()).registerTypeAdapter(OverlayLayer.class, (Object)new OverlayLayer.Deserializer()).registerTypeAdapter(Sound.class, (Object)new Sound.Deserializer()).create();
            AtomicInteger loadedSuccessfully = new AtomicInteger();
            fileLocations.entrySet().parallelStream().forEach(entry -> {
                ResourceLocation location = (ResourceLocation)entry.getKey();
                Resource resource = (Resource)entry.getValue();
                PixelTweaks.LOGGER.debug(location.toString());
                try {
                    InputStream stream = resource.open();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                    Event event = (Event)gson.fromJson((Reader)reader, Event.class);
                    event.pack = resource.sourcePackId();
                    event.file = location.getPath();
                    PixelTweaks.LOGGER.debug((Object)event);
                    EventRegistry.registerEvent(event);
                    loadedSuccessfully.getAndIncrement();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            PixelTweaks.LOGGER.info("Loaded " + String.valueOf(loadedSuccessfully) + " event files");
            return null;
        }, executor).thenAccept(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).wait(arg_0));
    }
}

