/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.tweaks;

import com.pixelmonmod.pixelmon.api.interactions.IInteraction;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.strangeone101.pixeltweaks.DamageHandler;
import com.strangeone101.pixeltweaks.PixelTweaks;
import com.strangeone101.pixeltweaks.TweaksConfig;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public class FoxImmunity {
    public FoxImmunity() {
        if (((Boolean)TweaksConfig.foxesLoveBerries.get()).booleanValue()) {
            PixelTweaks.LOGGER.info("Registered fox immunity tweak");
            NeoForge.EVENT_BUS.addListener(this::onEntityTakeDamage);
            PixelmonEntity.interactionList.add(new FoxInteraction());
            DamageHandler.registerPixelmonDamageSourceHandler("berry_bushes", (source, entity) -> {
                if (FoxImmunity.isFox(entity)) {
                    return Optional.of(false);
                }
                return Optional.empty();
            });
        }
    }

    public void onEntityTakeDamage(LivingDamageEvent.Pre event) {
        if (event.getSource().is(DamageTypes.SWEET_BERRY_BUSH) && event.getEntity() instanceof PixelmonEntity && FoxImmunity.isFox((PixelmonEntity)event.getEntity())) {
            event.setNewDamage(0.0f);
        }
    }

    public static boolean isFox(PixelmonEntity entity) {
        switch (entity.getSpecies().getDex()) {
            case 37: 
            case 38: 
            case 133: 
            case 570: 
            case 571: 
            case 653: 
            case 654: 
            case 655: 
            case 827: 
            case 828: {
                return true;
            }
        }
        return false;
    }

    public static class FoxInteraction
    implements IInteraction {
        public boolean processInteract(PixelmonEntity pixelmonEntity, Player playerEntity, InteractionHand hand, ItemStack itemStack) {
            if (playerEntity instanceof ServerPlayer && FoxImmunity.isFox(pixelmonEntity) && itemStack.getItem() == Items.SWEET_BERRIES) {
                if (pixelmonEntity.getPokemon().getHealth() < pixelmonEntity.getPokemon().getMaxHealth()) {
                    pixelmonEntity.getPokemon().setHealth(Math.min(pixelmonEntity.getPokemon().getHealth() + 5, pixelmonEntity.getPokemon().getMaxHealth()));
                    pixelmonEntity.level().playSound(null, pixelmonEntity.blockPosition(), SoundEvents.GENERIC_EAT, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    if (!playerEntity.isCreative()) {
                        itemStack.shrink(1);
                    }
                }
                return true;
            }
            return false;
        }
    }
}

