/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.tweaks;

import com.mojang.blaze3d.platform.Lighting;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.type.Type;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.SpriteItemHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.init.registry.ItemRegistration;
import com.strangeone101.pixeltweaks.PixelTweaks;
import com.strangeone101.pixeltweaks.TweaksConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemLore;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.ServerChatEvent;

public class PokeChat {
    private final Pattern pokemon = Pattern.compile("\\[pokemon]", 2);
    private final Pattern party = Pattern.compile("\\[party]", 2);
    private final Pattern slot = Pattern.compile("\\[(?:slot|pokemon)[(1-6)]]", 2);
    public static final int SCALE = 3;

    public PokeChat() {
        if (((Boolean)TweaksConfig.enablePokemonChat.get()).booleanValue()) {
            NeoForge.EVENT_BUS.addListener(this::onChat);
            if (FMLEnvironment.dist == Dist.CLIENT) {
                NeoForge.EVENT_BUS.addListener(this::onItemTooltip);
            }
        }
    }

    public void onChat(ServerChatEvent event) {
        long time = System.currentTimeMillis();
        try {
            if (event.getRawText().toLowerCase().matches(".*\\[(pokemon[1-6]?|party|slot[1-6])\\].*")) {
                for (int i = 0; i < 6; ++i) {
                    Pokemon pokemon = null;
                    Object usedMatcher = this.pokemon.toString();
                    Component c = event.getMessage();
                    String chat = c.getString();
                    Matcher matcher = this.pokemon.matcher(chat);
                    Matcher matcher2 = this.party.matcher(chat);
                    Matcher matcher3 = this.slot.matcher(chat);
                    if (matcher.find()) {
                        pokemon = ((PlayerPartyStorage)StorageProxy.getParty((Player)event.getPlayer()).get()).getSelectedPokemon();
                    } else if (matcher3.find()) {
                        int slot = Integer.parseInt(matcher3.group().replaceAll("[^1-6]", ""));
                        pokemon = ((PlayerPartyStorage)StorageProxy.getParty((Player)event.getPlayer()).get()).getAll()[slot - 1];
                        usedMatcher = "\\[(pokemon|slot)" + slot + "]";
                    }
                    if (pokemon == null) {
                        return;
                    }
                    MutableComponent component = pokemon.getDisplayName().copy();
                    Style style = component.getStyle().withBold(Boolean.valueOf(false)).withItalic(Boolean.valueOf(false)).withColor(ChatFormatting.GREEN);
                    component.withStyle(ChatFormatting.RESET);
                    HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(this.getItem(pokemon)));
                    component.withStyle(style.withHoverEvent(hoverEvent));
                    component = ComponentUtils.wrapInSquareBrackets((Component)component);
                    Component replaced = PokeChat.replaceInComponent(c, (String)usedMatcher, (Component)component);
                    event.setMessage(replaced);
                }
                PixelTweaks.LOGGER.error("PokeChat exceeded 6 loops with message of: " + event.getMessage().getString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Component replaceInComponent(Component baseComponent, String matcher, Component replacement) {
        if (baseComponent.getContents() instanceof PlainTextContents.LiteralContents) {
            String baseString = ((PlainTextContents.LiteralContents)baseComponent.getContents()).text();
            if (!baseString.replaceFirst(matcher, "").equals(baseString)) {
                String[] split = baseString.split(matcher, 2);
                String pre = split[0];
                MutableComponent newComponent = Component.literal((String)pre);
                newComponent.setStyle(baseComponent.getStyle());
                newComponent.append(replacement);
                if (pre.isEmpty()) {
                    newComponent = (MutableComponent)replacement;
                }
                if (split.length != 1 && !split[1].isEmpty()) {
                    String post = split[1];
                    MutableComponent postComponent = Component.literal((String)post);
                    postComponent.setStyle(baseComponent.getStyle());
                    newComponent.append((Component)postComponent);
                }
                for (Component sibling : baseComponent.getSiblings()) {
                    newComponent.append(sibling);
                }
                return newComponent;
            }
        } else if (baseComponent.getContents() instanceof TranslatableContents) {
            TranslatableContents baseCompTraslatable = (TranslatableContents)baseComponent.getContents();
            Object[] args = baseCompTraslatable.getArgs();
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof Component)) continue;
                args[i] = PokeChat.replaceInComponent((Component)args[i], matcher, replacement);
            }
            List siblings = baseComponent.getSiblings();
            baseComponent = Component.translatable((String)baseCompTraslatable.getKey(), (Object[])args);
            for (Component sib : siblings) {
                ((MutableComponent)baseComponent).append(sib);
            }
        }
        List siblings = baseComponent.getSiblings();
        ArrayList<Component> newSiblings = new ArrayList<Component>(siblings.size());
        for (Component sib : siblings) {
            newSiblings.add(PokeChat.replaceInComponent(sib, matcher, replacement));
        }
        baseComponent.getSiblings().clear();
        baseComponent.getSiblings().addAll(newSiblings);
        return baseComponent;
    }

    public ItemStack getItem(Pokemon pokemon) {
        ItemStack stack = SpriteItemHelper.getPhoto((Pokemon)pokemon);
        CustomData tag = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        MutableComponent name = pokemon.getDisplayName().copy();
        name.withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.DARK_GREEN});
        name = name.setStyle(name.getStyle().withItalic(Boolean.valueOf(false)));
        if (pokemon.getNickname() != null && !pokemon.getNickname().getString().equals("") && !pokemon.isEgg()) {
            name.append(" (");
            name.append((Component)pokemon.getSpecies().getNameTranslation());
            name.append(")");
        }
        stack.set(DataComponents.CUSTOM_NAME, (Object)name);
        ArrayList<MutableComponent> lore = new ArrayList<MutableComponent>();
        if (pokemon.isEgg()) {
            return stack;
        }
        if (pokemon.getSpecies().is(new RegistryValue[]{PixelmonSpecies.MISSINGNO})) {
            return PokeChat.getMissingNo();
        }
        if (!pokemon.getForm().getName().equals("") && !pokemon.getForm().getName().equals("none")) {
            MutableComponent form = Component.translatable((String)"gui.screenpokechecker.form", (Object[])new Object[]{Component.translatable((String)pokemon.getForm().getTranslationKey())});
            form.setStyle(form.getStyle().withItalic(Boolean.valueOf(false)));
            form.withStyle(ChatFormatting.GRAY);
            lore.add(form);
        }
        if (!pokemon.getPalette().getName().equals("") && !pokemon.getPalette().getName().equals("none")) {
            MutableComponent palette = Component.translatable((String)"gui.screenpokechecker.palette", (Object[])new Object[]{Component.translatable((String)pokemon.getPalette().getTranslationKey())});
            if (pokemon.isShiny()) {
                palette.setStyle(palette.getStyle().withColor(15247872).withItalic(Boolean.valueOf(false)));
            } else {
                palette.withStyle(ChatFormatting.GRAY).withStyle(style -> style.withItalic(Boolean.valueOf(false)));
            }
            lore.add(palette);
        }
        lore.add(Component.literal((String)""));
        MutableComponent lvl = Component.translatable((String)"pixelmon.command.pokemoninfo.level");
        lvl.setStyle(lvl.getStyle().withItalic(Boolean.valueOf(false)));
        lvl.withStyle(ChatFormatting.GREEN);
        lvl.append(": ");
        lvl.append((Component)Component.literal((String)String.valueOf(pokemon.getPokemonLevel())).withStyle(ChatFormatting.YELLOW));
        lore.add(lvl);
        if (pokemon.getGender() != Gender.NONE) {
            MutableComponent gender = Component.translatable((String)"pixelmon.command.pokemoninfo.gender");
            gender.setStyle(gender.getStyle().withItalic(Boolean.valueOf(false)));
            gender.withStyle(ChatFormatting.GREEN);
            gender.append(": ");
            Style style2 = Style.EMPTY.withColor(pokemon.getGender() == Gender.FEMALE ? 0xFF6464 : 0x6464FF).withItalic(Boolean.valueOf(false));
            gender.append((Component)Component.translatable((String)pokemon.getGender().getTranslationKey()).withStyle(style2));
            lore.add(gender);
        }
        MutableComponent ability = Component.translatable((String)"pixelmon.command.pokemoninfo.ability");
        ability.setStyle(ability.getStyle().withItalic(Boolean.valueOf(false)));
        ability.withStyle(ChatFormatting.GREEN);
        ability.append(": ");
        ability.append((Component)pokemon.getAbility().getTranslatedName().withStyle(ChatFormatting.YELLOW));
        if (pokemon.getForm().getAbilities().isHiddenAbility(new Ability[]{pokemon.getAbility()})) {
            MutableComponent hidden = Component.literal((String)" (");
            hidden.setStyle(hidden.getStyle().withItalic(Boolean.valueOf(false)));
            hidden.withStyle(ChatFormatting.GREEN);
            hidden.append((Component)Component.translatable((String)"type.ha").withStyle(ChatFormatting.LIGHT_PURPLE));
            hidden.append(")");
            ability.append((Component)hidden);
        }
        lore.add(ability);
        MutableComponent pokeball = Component.translatable((String)"gui.pokemoneditor.pokeball");
        pokeball.setStyle(pokeball.getStyle().withItalic(Boolean.valueOf(false)));
        pokeball.withStyle(ChatFormatting.GREEN);
        pokeball.append(": ");
        pokeball.append((Component)Component.translatable((String)pokemon.getBall().getTranslationKey()).withStyle(ChatFormatting.YELLOW));
        lore.add(pokeball);
        MutableComponent nature = Component.translatable((String)"pixelmon.command.pokemoninfo.nature");
        nature.setStyle(nature.getStyle().withItalic(Boolean.valueOf(false)));
        nature.withStyle(ChatFormatting.GREEN);
        nature.append(": ");
        nature.append((Component)Component.translatable((String)pokemon.getNature().getTranslationKey()).withStyle(ChatFormatting.YELLOW));
        lore.add(nature);
        MutableComponent moves = Component.translatable((String)"pixelmon.command.pokemoninfo.moves");
        moves.setStyle(moves.getStyle().withItalic(Boolean.valueOf(false)));
        moves.withStyle(ChatFormatting.GREEN);
        moves.append(": ");
        if (pokemon.getMoveset().isEmpty()) {
            MutableComponent none = Component.literal((String)" (");
            none.setStyle(none.getStyle().withItalic(Boolean.valueOf(false)));
            none.withStyle(ChatFormatting.GREEN);
            none.append((Component)Component.translatable((String)"pixelmon.command.pokemoninfo.none").withStyle(ChatFormatting.GRAY));
            none.append(")");
            moves.append((Component)none);
        } else {
            for (int i = 0; i < pokemon.getMoveset().size(); ++i) {
                if (i != 0) {
                    MutableComponent spacer = Component.literal((String)" | ");
                    spacer.setStyle(spacer.getStyle().withItalic(Boolean.valueOf(false)));
                    spacer.withStyle(ChatFormatting.GRAY);
                    moves.append((Component)spacer);
                }
                ImmutableAttack attack = pokemon.getMoveset().get(i).getActualMove();
                MutableComponent attackComponent = attack.getTranslatedName().withStyle(Style.EMPTY.withColor(((Type)attack.getAttackType().value()).color().getRGB()).withItalic(Boolean.valueOf(false)));
                moves.append((Component)attackComponent);
            }
        }
        lore.add(moves);
        ItemLore itemLore = new ItemLore(lore);
        stack.set(DataComponents.LORE, (Object)itemLore);
        stack.set(DataComponents.CUSTOM_DATA, (Object)tag.update(t -> t.putBoolean("PokeChat", true)));
        return stack;
    }

    public static ItemStack getMissingNo() {
        Pokemon pokemon = ((PokemonSpecification)PokemonSpecificationProxy.create((String[])new String[]{"missingno"}).get()).create();
        ItemStack stack = SpriteItemHelper.getPhoto((Pokemon)pokemon);
        MutableComponent name = pokemon.getTranslatedName();
        name.withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.DARK_GREEN});
        name = name.setStyle(name.getStyle().withItalic(Boolean.valueOf(false)));
        stack.set(DataComponents.CUSTOM_NAME, (Object)name);
        ArrayList<MutableComponent> lore = new ArrayList<MutableComponent>();
        int lines = ThreadLocalRandom.current().nextInt(5) + 5;
        for (int i = 0; i < lines; ++i) {
            int length = ThreadLocalRandom.current().nextInt(4) + 2 + 4 * (i % 3);
            char[] chars = new char[]{'\ufffd', '\ufffe', '\uffff', '\ufffd', '\uffff', '\ufffe', '\ufffd'};
            Object s = "";
            for (int j = 0; j < length; ++j) {
                s = (String)s + chars[(i * 7 + length + j * 3) % 7];
            }
            MutableComponent stc = Component.literal((String)s);
            lore.add(stc.setStyle(stc.getStyle().withItalic(Boolean.valueOf(false)).withColor(ChatFormatting.WHITE)));
        }
        stack.set(DataComponents.LORE, (Object)new ItemLore(lore));
        CustomData tag = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        stack.set(DataComponents.CUSTOM_DATA, (Object)tag.update(t -> t.putBoolean("PokeChat", true)));
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onItemTooltip(RenderTooltipEvent.Color event) {
        if (event.getItemStack().getItem() == ItemRegistration.PIXELMON_SPRITE.get() && event.getItemStack().get(DataComponents.CUSTOM_DATA) != null && ((CustomData)event.getItemStack().get(DataComponents.CUSTOM_DATA)).contains("PokeChat")) {
            int width = 0;
            for (ClientTooltipComponent clienttooltipcomponent : event.getComponents()) {
                int tempWidth = clienttooltipcomponent.getWidth(event.getFont());
                if (tempWidth <= width) continue;
                width = tempWidth;
            }
            this.renderItem(event.getGraphics(), event.getItemStack(), event.getX() + width - 48, event.getY());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderItem(GuiGraphics matrixStack, ItemStack stack, int x, int y) {
        float half = 24.0f;
        float full = 48.0f;
        BakedModel bakedmodel = Minecraft.getInstance().getItemRenderer().getItemModelShaper().getItemModel(stack);
        bakedmodel = bakedmodel.getOverrides().resolve(bakedmodel, stack, Minecraft.getInstance().level, (LivingEntity)Minecraft.getInstance().player, 0);
        matrixStack.pose().pushPose();
        boolean lightingFlag = !bakedmodel.usesBlockLight();
        matrixStack.pose().translate((float)x + half, (float)y + half, 1150.0f);
        matrixStack.pose().scale(full, -full, full);
        if (lightingFlag) {
            Lighting.setupForFlatItems();
        }
        Minecraft.getInstance().getItemRenderer().render(stack, ItemDisplayContext.GUI, false, matrixStack.pose(), (MultiBufferSource)matrixStack.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, bakedmodel);
        matrixStack.flush();
        if (lightingFlag) {
            Lighting.setupFor3DItems();
        }
        matrixStack.pose().popPose();
    }
}

