/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.strangeone101.pixeltweaks.ClientScheduler;
import com.strangeone101.pixeltweaks.TweaksConfig;
import com.strangeone101.pixeltweaks.particle.StarParticle;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ShinyTracker {
    public static final ShinyTracker INSTANCE = new ShinyTracker();
    private Set<Pokemon> shinyMap = new HashSet<Pokemon>();
    private Set<PixelmonEntity> shinyTracking = new HashSet<PixelmonEntity>();
    public Frustum camera = null;
    private double range = (Double)TweaksConfig.shinySparkleRange.get();
    private float volume = Math.min(((Double)TweaksConfig.shinySparkleVolume.get()).floatValue(), 2.0f);

    public boolean shouldTrackShiny(PixelmonEntity entity) {
        return !entity.isUncatchable() && entity.isAlive() && !entity.isBossPokemon() && entity.getOwner() == null && entity.getPokemon().isShiny() && !this.shinyMap.contains(entity.getPokemon()) && !this.shinyTracking.contains(entity);
    }

    public void track(PixelmonEntity entity) {
        this.shinyTracking.add(entity);
    }

    public void tick() {
        if (BattleRegistry.getBattle((Entity)Minecraft.getInstance().player) != null || this.camera == null) {
            return;
        }
        this.shinyTracking.removeIf(entity -> !entity.isLoaded() || !entity.isAlive());
        Vector3f vec = Minecraft.getInstance().gameRenderer.getMainCamera().getLookVector();
        Vec3 pos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        this.camera.prepare(pos.x, pos.y, pos.z);
        Iterator<PixelmonEntity> iterator = this.shinyTracking.iterator();
        while (iterator.hasNext()) {
            PixelmonEntity entity2 = iterator.next();
            boolean rendered = Minecraft.getInstance().getEntityRenderDispatcher().shouldRender((Entity)entity2, this.camera, pos.x, pos.y, pos.z);
            boolean visible = this.rayTrace(entity2);
            if (!(entity2.position().distanceToSqr(Minecraft.getInstance().player.position()) <= this.range * this.range) || !rendered || !visible) continue;
            iterator.remove();
            ClientScheduler.schedule(10, () -> {
                Vec3 pos2 = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
                this.camera.prepare(pos2.x, pos2.y, pos2.z);
                boolean rendered2 = Minecraft.getInstance().getEntityRenderDispatcher().shouldRender((Entity)entity2, this.camera, pos2.x, pos2.y, pos2.z);
                if (rendered2 && this.rayTrace(entity2)) {
                    this.shinyMap.add(entity2.getPokemon());
                    this.spawnSparkle(entity2);
                } else {
                    this.shinyTracking.add(entity2);
                }
            });
        }
    }

    public void untrackAll() {
        this.shinyTracking.clear();
    }

    public boolean rayTrace(PixelmonEntity entity) {
        LocalPlayer player = Minecraft.getInstance().player;
        Vec3 from = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        Vec3 to = entity.position();
        if (entity.level() != player.level() || from.distanceToSqr(to) > 16384.0) {
            return false;
        }
        BlockHitResult result = entity.level().clip(new ClipContext(Minecraft.getInstance().gameRenderer.getMainCamera().getPosition(), entity.position(), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)entity));
        return result.getType() == HitResult.Type.MISS;
    }

    public void spawnSparkle(PixelmonEntity entity) {
        LocalPlayer thiz = Minecraft.getInstance().player;
        if (this.volume > 0.0f) {
            ClientScheduler.schedule(3, () -> {
                SimpleSoundInstance sound = new SimpleSoundInstance(ResourceLocation.fromNamespaceAndPath((String)"pixeltweaks", (String)"sparkle"), SoundSource.PLAYERS, this.volume, 1.0f, RandomSource.create(), false, 0, SoundInstance.Attenuation.LINEAR, entity.getX(), entity.getY(), entity.getZ(), false);
                Minecraft.getInstance().getSoundManager().play((SoundInstance)sound);
            });
        }
        double d = (double)entity.getBbWidth() / 2.5 + 0.2;
        double h = entity.getBoundingBoxForCulling().getYsize() / 2.5;
        double boxSize = Math.cbrt(entity.getBoundingBoxForCulling().getXsize() * entity.getBoundingBoxForCulling().getYsize() * entity.getBoundingBoxForCulling().getZsize());
        int amount = (int)Math.max(5.0, Math.min(boxSize * 5.0, 50.0));
        int div = 360 / amount;
        for (int i = 0; i < amount; ++i) {
            double deg = (float)(i * div) + ((float)entity.level().random.nextInt(div / 6) - (float)div / 3.0f);
            double xx = Math.cos(Math.toRadians(deg));
            double zz = Math.sin(Math.toRadians(deg));
            double driftX = (entity.level().random.nextDouble() * 0.2 - 0.1) * d;
            double driftY = (entity.level().random.nextDouble() * 0.4 - 0.15) * h;
            double driftZ = (entity.level().random.nextDouble() * 0.2 - 0.1) * d;
            double x = xx * d + entity.getX() + driftX;
            double y = h + entity.getY() + driftY;
            double z = zz * d + entity.getZ() + driftZ;
            double xo = entity.getDeltaMovement().x;
            double yo = entity.getDeltaMovement().y;
            double zo = entity.getDeltaMovement().z;
            StarParticle particle = new StarParticle(Minecraft.getInstance().level, x, y, z, 0.01 * xx + xo, 0.1 * (double)entity.getBbHeight() + yo, 0.01 * zz + zo);
            Minecraft.getInstance().particleEngine.add((Particle)particle);
        }
    }
}

