/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.client.overlay;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.strangeone101.pixeltweaks.client.overlay.OverlayLayer;
import com.strangeone101.pixeltweaks.pixelevents.Condition;
import com.strangeone101.pixeltweaks.pixelevents.Event;
import com.strangeone101.pixeltweaks.pixelevents.EventRegistry;
import com.strangeone101.pixeltweaks.pixelevents.IValidator;
import com.strangeone101.pixeltweaks.pixelevents.condition.PokemonCondition;
import com.strangeone101.pixeltweaks.pixelevents.condition.PokemonListCondition;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class PokemonOverlay
extends Event
implements IValidator {
    public static Map<PokemonSpecification, Set<PokemonOverlay>> NON_SPECIES_EVENT = new LinkedHashMap<PokemonSpecification, Set<PokemonOverlay>>();
    public static Map<Species, Map<PokemonSpecification, Set<PokemonOverlay>>> SPECIES_EVENTS = new HashMap<Species, Map<PokemonSpecification, Set<PokemonOverlay>>>();
    public OverlayLayer[] layers;
    public int dualModelLayer = 0;

    @Override
    public boolean isClientSide() {
        return true;
    }

    @Override
    public boolean validate() {
        return this.conditions.stream().anyMatch(c -> c instanceof PokemonCondition || c instanceof PokemonListCondition) && this.layers.length > 0;
    }

    @Override
    public String getError() {
        return "At least one condition must be a pokemon condition and there must be at least one layer!";
    }

    public static void onAllRegistered() {
        Collection<PokemonOverlay> events = EventRegistry.getEvents(PokemonOverlay.class);
        for (PokemonOverlay overlay : events) {
            for (Condition c2 : overlay.conditions) {
                if (c2 instanceof PokemonCondition) {
                    PokemonSpecification spec2 = ((PokemonCondition)c2).spec;
                    if (spec2.getRequirement(SpeciesRequirement.class).isPresent()) {
                        Species species = spec2.create().getSpecies();
                        SPECIES_EVENTS.putIfAbsent(species, new HashMap());
                        SPECIES_EVENTS.get(species).putIfAbsent(spec2, new LinkedHashSet());
                        SPECIES_EVENTS.get(species).get(spec2).add(overlay);
                        continue;
                    }
                    NON_SPECIES_EVENT.putIfAbsent(spec2, new LinkedHashSet());
                    NON_SPECIES_EVENT.get(spec2).add(overlay);
                    continue;
                }
                if (!(c2 instanceof PokemonListCondition)) continue;
                ((PokemonListCondition)c2).spec.forEach(spec -> {
                    if (spec.getRequirement(SpeciesRequirement.class).isPresent()) {
                        Species species = spec.create().getSpecies();
                        SPECIES_EVENTS.putIfAbsent(species, new HashMap());
                        SPECIES_EVENTS.get(species).putIfAbsent((PokemonSpecification)spec, new LinkedHashSet());
                        SPECIES_EVENTS.get(species).get(spec).add(overlay);
                    } else {
                        NON_SPECIES_EVENT.putIfAbsent((PokemonSpecification)spec, new LinkedHashSet());
                        NON_SPECIES_EVENT.get(spec).add(overlay);
                    }
                });
            }
            overlay.conditions = overlay.conditions.stream().filter(c -> !(c instanceof PokemonCondition) && !(c instanceof PokemonListCondition)).collect(Collectors.toList());
        }
    }

    private static TreeSet<PokemonOverlay> newTreeset() {
        return Sets.newTreeSet((e1, e2) -> {
            if (e1.getPriority() == e2.getPriority()) {
                return e2.hashCode() - e1.hashCode();
            }
            return e2.getPriority() - e1.getPriority();
        });
    }

    @Override
    public String toString() {
        return "PokemonOverlay{layers=" + Arrays.toString(this.layers) + ", dualModelLayer=" + this.dualModelLayer + ", conditions=" + String.valueOf(this.conditions) + ", priority=" + this.priority + "}";
    }
}

