/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.integration.ftbquests;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.pokemon.requirement.impl.BossRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.FormRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.PaletteRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.TypeRequirement;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.GenderProperties;
import com.pixelmonmod.pixelmon.api.pokemon.type.Type;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.init.registry.PixelmonRegistry;
import com.strangeone101.pixeltweaks.PixelTweaks;
import com.strangeone101.pixeltweaks.mixin.AbstractSpecificationMixin;
import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;

public class PokemonConfig
extends ConfigFromString<PokemonSpecification> {
    private static final Map<Integer, Set<String>> CACHE = new HashMap<Integer, Set<String>>();
    private boolean requiresSpecies;

    public PokemonConfig(boolean requiresSpecies) {
        this.requiresSpecies = requiresSpecies;
    }

    public String getStringFromValue(PokemonSpecification v) {
        return v == null ? "" : v.toString();
    }

    public boolean parse(Consumer<PokemonSpecification> consumer, String s) {
        try {
            List requirements;
            if (s.isEmpty()) {
                if (!this.requiresSpecies) {
                    if (consumer != null) {
                        consumer.accept(null);
                    }
                    return true;
                }
                return false;
            }
            if (s.charAt(0) == '*') {
                if (consumer != null) {
                    consumer.accept((PokemonSpecification)PokemonSpecificationProxy.create((String[])new String[]{s.substring(1)}).get());
                }
                return true;
            }
            PokemonSpecification pokemonSpecification = (PokemonSpecification)PokemonSpecificationProxy.create((String[])new String[]{s}).get();
            String[] args = s.split(" ");
            if (!this.requiresSpecies && args[0].equalsIgnoreCase("random")) {
                return false;
            }
            if (this.requiresSpecies) {
                if (args[0].equalsIgnoreCase("random")) {
                    if (consumer != null) {
                        consumer.accept(pokemonSpecification);
                    }
                    return true;
                }
                if (!pokemonSpecification.getValue(SpeciesRequirement.class).isPresent() || ((RegistryValue)pokemonSpecification.getValue(SpeciesRequirement.class).get()).getKey().equalsIgnoreCase("MISSINGNO")) {
                    return false;
                }
            }
            int toMatch = args.length;
            if (args[0].equalsIgnoreCase("random")) {
                --toMatch;
            }
            if ((requirements = ((AbstractSpecificationMixin)pokemonSpecification).getRequirements()).size() != toMatch) {
                return false;
            }
            for (Requirement requirement : requirements) {
                if (this.isCorrect(requirement, pokemonSpecification)) continue;
                return false;
            }
            if (consumer != null) {
                consumer.accept(pokemonSpecification);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isCorrect(Requirement<?, ?, ?> requirement, PokemonSpecification s) {
        if (requirement instanceof SpeciesRequirement) {
            return ((SpeciesRequirement)requirement).getValue().getValue().isPresent();
        }
        if (requirement instanceof TypeRequirement) {
            int inString;
            TypeRequirement typer = (TypeRequirement)requirement;
            int place = (Integer)((TypeRequirement)requirement).getValue().getFirst();
            Object stringPlace = "type:";
            if (place != -1) {
                stringPlace = "type" + place + ":";
            }
            if ((inString = s.toString().indexOf((String)stringPlace)) == -1) {
                return false;
            }
            String type = s.toString().substring(inString + ((String)stringPlace).length()).split(" ")[0];
            ResourceKey pixelmonType = Type.parseOrNull((String)("pixelmon:" + type.toLowerCase()));
            Type realType = (Type)((Registry)Minecraft.getInstance().level.registryAccess().registry(PixelmonRegistry.TYPE_REGISTRY).get()).get(pixelmonType);
            PixelTweaks.LOGGER.info(realType == null ? "null" : realType.name().getString());
            return realType != null;
        }
        if (requirement instanceof FormRequirement) {
            String form;
            String string = form = ((FormRequirement)requirement).getValue().equalsIgnoreCase("none") ? "" : ((FormRequirement)requirement).getValue();
            if (s.getValue(SpeciesRequirement.class).isPresent() && !s.toString().split(" ")[0].equalsIgnoreCase("random")) {
                return form.equals("base") || form.equals("none") || ((Species)((RegistryValue)s.getValue(SpeciesRequirement.class).get()).getValue().get()).hasForm(form);
            }
            return PixelmonSpecies.getAll().stream().anyMatch(species -> species.hasForm(form));
        }
        if (requirement instanceof PaletteRequirement) {
            if (s.getValue(SpeciesRequirement.class).isPresent() && !s.toString().split(" ")[0].equalsIgnoreCase("random")) {
                Species species2 = (Species)((RegistryValue)s.getValue(SpeciesRequirement.class).get()).getValue().get();
                if (!CACHE.containsKey(species2.getDex())) {
                    CACHE.put(species2.getDex(), species2.getForms().stream().map(Stats::getGenderProperties).flatMap(Collection::stream).map(GenderProperties::getPalettes).flatMap(Arrays::stream).map(palette -> palette.getName().toLowerCase()).collect(Collectors.toSet()));
                }
                return CACHE.get(species2.getDex()).contains(((PaletteRequirement)requirement).getValue().toLowerCase());
            }
            if (!CACHE.containsKey(-1)) {
                CACHE.put(-1, PixelmonSpecies.getAll().stream().map(Species::getForms).flatMap(Collection::stream).map(Stats::getGenderProperties).flatMap(Collection::stream).map(GenderProperties::getPalettes).flatMap(Arrays::stream).map(palette -> palette.getName().toLowerCase()).collect(Collectors.toSet()));
            }
            return CACHE.get(-1).contains(((PaletteRequirement)requirement).getValue().toLowerCase());
        }
        if (requirement instanceof BossRequirement) {
            return ((BossRequirement)requirement).getValue() != null;
        }
        return requirement.fits(s.toString()) && requirement.getValue() != null;
    }
}

