/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.integration.ftbquests;

import com.mojang.datafixers.util.Pair;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.pokemon.requirement.impl.EggRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.FormRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.GenderRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.GenerationRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.LegendaryRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.PaletteRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.PokeBallRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.PokerusRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.ShinyRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.TypeRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.UltraBeastRequirement;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.PokerusStrain;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.strangeone101.pixeltweaks.integration.ftbquests.PokemonConfig;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.task.Task;
import java.util.ArrayList;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public abstract class PokemonTask
extends Task {
    public int count = 1;
    public boolean invert = false;
    public transient PokemonSpecification cachedSpec;

    public PokemonTask(long id, Quest q) {
        super(id, q);
    }

    public long getMaxProgress() {
        return this.count;
    }

    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putString("pokemon", this.cachedSpec == null ? "" : this.cachedSpec.toString());
        nbt.putInt("count", this.count);
        nbt.putBoolean("invert", this.invert);
    }

    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        String pokemonSpec = nbt.getString("pokemon");
        this.cachedSpec = pokemonSpec.isEmpty() ? null : (PokemonSpecification)PokemonSpecificationProxy.create((String[])new String[]{pokemonSpec}).get();
        this.count = nbt.getInt("count");
        this.invert = nbt.getBoolean("invert");
    }

    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeUtf(this.cachedSpec == null ? "" : this.cachedSpec.toString());
        buffer.writeVarInt(this.count);
        buffer.writeBoolean(this.invert);
    }

    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        String pokemonSpec = buffer.readUtf();
        this.cachedSpec = pokemonSpec.isEmpty() ? null : (PokemonSpecification)PokemonSpecificationProxy.create((String[])new String[]{pokemonSpec}).get();
        this.count = buffer.readVarInt();
        this.invert = buffer.readBoolean();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.add("pokemon", (ConfigValue)new PokemonConfig(false), (Object)this.cachedSpec, v -> {
            this.cachedSpec = v;
        }, null);
        config.addInt("count", this.count, v -> {
            this.count = v;
        }, 1, 1, Integer.MAX_VALUE);
        config.addBool("invert", this.invert, v -> {
            this.invert = v;
        }, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getAltTitle() {
        MutableComponent title = Component.translatable((String)("ftbquests.task." + this.getType().getTypeId().getNamespace() + "." + this.getType().getTypeId().getPath() + ".title"));
        title.append(" ");
        if (this.count > 1) {
            title.append(this.count + "x ");
        }
        title.append(this.getPokemon());
        return title;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        if (this.cachedSpec != null && this.cachedSpec.getValue(SpeciesRequirement.class).isPresent() && !this.cachedSpec.toString().isEmpty() && !this.cachedSpec.toString().split(" ")[0].equalsIgnoreCase("random")) {
            return Icon.getIcon((ResourceLocation)this.cachedSpec.create().getSprite());
        }
        return super.getAltIcon();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected Component getPokemon() {
        return PokemonTask.getPokemon(this.cachedSpec);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Component getPokemon(PokemonSpecification spec) {
        MutableComponent pokemon = Component.translatable((String)"pixeltweaks.lang.pokemon");
        if (spec == null) {
            return pokemon;
        }
        ArrayList<MutableComponent> componentList = new ArrayList<MutableComponent>();
        if (spec.getValue(PokerusRequirement.class).isPresent()) {
            boolean pokerus;
            boolean bl = pokerus = spec.getValue(PokerusRequirement.class).get() != PokerusStrain.UNINFECTED;
            if (pokerus) {
                MutableComponent pokerusText = Component.translatable((String)"pixeltweaks.lang.pokerus");
                componentList.add(pokerusText);
            }
        }
        if (spec.getValue(SpeciesRequirement.class).isPresent()) {
            MutableComponent species = ((Species)((RegistryValue)spec.getValue(SpeciesRequirement.class).get()).getValueUnsafe()).getNameTranslation();
            componentList.add(species);
        } else {
            MutableComponent nonText;
            if (spec.getValue(LegendaryRequirement.class).isPresent()) {
                boolean legend = (Boolean)spec.getValue(LegendaryRequirement.class).get();
                if (!legend) {
                    legendText = Component.translatable((String)"pixeltweaks.lang.legendary");
                    nonText = Component.translatable((String)"pixeltweaks.lang.not", (Object[])new Object[]{legendText});
                    componentList.add(nonText);
                } else {
                    legendText = Component.translatable((String)"pixeltweaks.lang.legendary");
                    componentList.add(legendText);
                }
            }
            if (spec.getValue(UltraBeastRequirement.class).isPresent()) {
                boolean ultra = (Boolean)spec.getValue(UltraBeastRequirement.class).get();
                if (!ultra) {
                    ultraText = Component.translatable((String)"pixeltweaks.lang.ultrabeast");
                    nonText = Component.translatable((String)"pixeltweaks.lang.not", (Object[])new Object[]{ultraText});
                    componentList.add(nonText);
                } else {
                    ultraText = Component.translatable((String)"pixeltweaks.lang.ultrabeast");
                    componentList.add(ultraText);
                }
            }
            if (spec.getValue(GenerationRequirement.class).isPresent()) {
                MutableComponent newType = Component.translatable((String)"pixeltweaks.lang.generation", (Object[])new Object[]{spec.getValue(GenerationRequirement.class).get()});
                componentList.add(newType);
            }
            if (spec.getValue(TypeRequirement.class).isPresent()) {
                MutableComponent type = Component.translatable((String)("type." + ((ResourceKey)((Pair)spec.getValue(TypeRequirement.class).get()).getSecond()).location().getPath().toString().toLowerCase()));
                MutableComponent newType = Component.translatable((String)"pixeltweaks.lang.type", (Object[])new Object[]{type});
                componentList.add(newType);
            }
            componentList.add(0, pokemon);
        }
        if (spec.getValue(FormRequirement.class).isPresent()) {
            Species species;
            String form = ((String)spec.getValue(FormRequirement.class).get()).toLowerCase();
            MutableComponent formComponent = Component.translatable((String)("pixelmon.generic.form." + form));
            if (spec.getValue(SpeciesRequirement.class).isPresent() && I18n.exists((String)("pixelmon." + (species = (Species)((RegistryValue)spec.getValue(SpeciesRequirement.class).get()).getValueUnsafe()).getName().toLowerCase() + ".form." + form))) {
                formComponent = Component.translatable((String)("pixelmon." + species.getName().toLowerCase() + ".form." + form));
            }
            componentList.add(formComponent);
        }
        if (spec.getValue(PaletteRequirement.class).isPresent()) {
            MutableComponent form = Component.translatable((String)("pixelmon.palette." + ((String)spec.getValue(PaletteRequirement.class).get()).toLowerCase()));
            componentList.add(form);
        }
        if (spec.getValue(GenderRequirement.class).isPresent()) {
            MutableComponent gender = Component.translatable((String)((Gender)spec.getValue(GenderRequirement.class).get()).getTranslationKey());
            componentList.add(gender);
        }
        if (spec.getValue(ShinyRequirement.class).isPresent()) {
            boolean bool = (Boolean)((Requirement)spec.getRequirement(ShinyRequirement.class).get()).getValue();
            MutableComponent shiny = Component.translatable((String)"pixelmon.palette.shiny");
            if (!bool) {
                shiny = Component.translatable((String)"pixeltweaks.lang.not", (Object[])new Object[]{Component.translatable((String)"pixelmon.palette.shiny")});
            }
            componentList.add(shiny);
        }
        if (spec.getValue(EggRequirement.class).isPresent()) {
            boolean bool = (Boolean)((Requirement)spec.getRequirement(EggRequirement.class).get()).getValue();
            MutableComponent egg = Component.translatable((String)"pixelmon.egg");
            if (!bool) {
                egg = Component.translatable((String)"pixeltweaks.lang.not", (Object[])new Object[]{Component.translatable((String)"pixelmon.egg")});
            }
            componentList.add(egg);
        }
        if (spec.getValue(PokeBallRequirement.class).isPresent()) {
            MutableComponent ball = Component.translatable((String)("item.pixelmon." + ((PokeBall)spec.getValue(PokeBallRequirement.class).get()).getName().toLowerCase()));
            MutableComponent ballText = Component.translatable((String)"pixeltweaks.lang.ball", (Object[])new Object[]{ball});
            componentList.add(ballText);
        }
        MutableComponent all = Component.literal((String)"");
        for (int i = componentList.size() - 1; i >= 0; --i) {
            all.append((Component)componentList.get(i));
            if (i == 0) continue;
            all.append(" ");
        }
        return all;
    }
}

