/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.integration.ftbquests;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BattleResults;
import com.pixelmonmod.pixelmon.api.daycare.event.DayCareEvent;
import com.pixelmonmod.pixelmon.api.economy.EconomyEvent;
import com.pixelmonmod.pixelmon.api.enums.DeleteType;
import com.pixelmonmod.pixelmon.api.events.CameraEvent;
import com.pixelmonmod.pixelmon.api.events.CaptureEvent;
import com.pixelmonmod.pixelmon.api.events.EggHatchEvent;
import com.pixelmonmod.pixelmon.api.events.EvolveEvent;
import com.pixelmonmod.pixelmon.api.events.LevelUpEvent;
import com.pixelmonmod.pixelmon.api.events.PixelmonDeletedEvent;
import com.pixelmonmod.pixelmon.api.events.PokemonReceivedEvent;
import com.pixelmonmod.pixelmon.api.events.battles.AttackEvent;
import com.pixelmonmod.pixelmon.api.events.battles.BattleEndEvent;
import com.pixelmonmod.pixelmon.api.events.moveskills.UseMoveSkillEvent;
import com.pixelmonmod.pixelmon.api.pokedex.event.PokedexEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.BattleStage;
import com.pixelmonmod.pixelmon.battles.controller.participants.EntityParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.entities.npcs.NPC;
import com.strangeone101.pixeltweaks.PixelTweaks;
import com.strangeone101.pixeltweaks.integration.ftbquests.TaskUtils;
import com.strangeone101.pixeltweaks.integration.ftbquests.tasks.BattleMoveTask;
import com.strangeone101.pixeltweaks.integration.ftbquests.tasks.BreedTask;
import com.strangeone101.pixeltweaks.integration.ftbquests.tasks.CatchTask;
import com.strangeone101.pixeltweaks.integration.ftbquests.tasks.DefeatPlayersTask;
import com.strangeone101.pixeltweaks.integration.ftbquests.tasks.DefeatTask;
import com.strangeone101.pixeltweaks.integration.ftbquests.tasks.DefeatTrainerTask;
import com.strangeone101.pixeltweaks.integration.ftbquests.tasks.EvolutionTask;
import com.strangeone101.pixeltweaks.integration.ftbquests.tasks.ExternalMoveTask;
import com.strangeone101.pixeltweaks.integration.ftbquests.tasks.HatchTask;
import com.strangeone101.pixeltweaks.integration.ftbquests.tasks.LevelTask;
import com.strangeone101.pixeltweaks.integration.ftbquests.tasks.PhotoTask;
import com.strangeone101.pixeltweaks.integration.ftbquests.tasks.PokeDollarsTask;
import com.strangeone101.pixeltweaks.integration.ftbquests.tasks.PokedexAmountTask;
import com.strangeone101.pixeltweaks.integration.ftbquests.tasks.PokedexPercentageTask;
import com.strangeone101.pixeltweaks.integration.ftbquests.tasks.PokedexTask;
import com.strangeone101.pixeltweaks.integration.ftbquests.tasks.ReleaseTask;
import com.strangeone101.pixeltweaks.integration.ftbquests.tasks.TradeTask;
import com.strangeone101.pixeltweaks.integration.ftbquests.tasks.WipeoutTask;
import dev.ftb.mods.ftbquests.events.ClearFileCacheEvent;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class TaskListener {
    private List<CatchTask> catchTasks = null;
    private List<DefeatTask> defeatTasks = null;
    private List<TradeTask> tradeTasks = null;
    private List<PokeDollarsTask> pokeDollarsTasks = null;
    private List<EvolutionTask> evolutionTasks = null;
    private List<HatchTask> hatchTasks = null;
    private List<BreedTask> breedTasks = null;
    private List<PokedexTask> pokedexTasks = null;
    private List<LevelTask> levelTasks = null;
    private List<WipeoutTask> wipeoutTasks = null;
    private List<DefeatTrainerTask> defeatTrainerTasks = null;
    private List<DefeatPlayersTask> defeatPlayersTasks = null;
    private List<BattleMoveTask> battleMoveTasks = null;
    private List<PhotoTask> photoTasks = null;
    private List<ExternalMoveTask> externalMoveTasks = null;
    private List<ReleaseTask> releaseTasks = null;
    @Deprecated
    private Set<UUID> antiOverflow = new HashSet<UUID>();
    private Set<UUID> hatchCommandFix = new HashSet<UUID>();
    private Set<Attack> battleMoveFix = new HashSet<Attack>();

    public TaskListener() {
        Pixelmon.EVENT_BUS.addListener(EventPriority.LOWEST, this::betterOnCatch);
        Pixelmon.EVENT_BUS.addListener(EventPriority.LOWEST, this::onDefeatPokemon);
        Pixelmon.EVENT_BUS.addListener(EventPriority.LOWEST, this::onRaidCatch);
        Pixelmon.EVENT_BUS.addListener(EventPriority.LOWEST, this::onEvolve);
        Pixelmon.EVENT_BUS.addListener(EventPriority.LOWEST, this::onHatch);
        Pixelmon.EVENT_BUS.addListener(EventPriority.LOWEST, this::onBreed);
        Pixelmon.EVENT_BUS.addListener(EventPriority.LOW, this::onPokedexUpdate);
        Pixelmon.EVENT_BUS.addListener(EventPriority.LOWEST, this::onLevelUp);
        Pixelmon.EVENT_BUS.addListener(EventPriority.LOWEST, this::onWipeout);
        Pixelmon.EVENT_BUS.addListener(EventPriority.LOWEST, this::onBattleMove);
        Pixelmon.EVENT_BUS.addListener(EventPriority.LOWEST, this::onTakePhoto);
        Pixelmon.EVENT_BUS.addListener(EventPriority.LOWEST, this::onExternalMove);
        Pixelmon.EVENT_BUS.addListener(EventPriority.LOWEST, this::onPokemonRelease);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOW, this::onLogin);
        ClearFileCacheEvent.EVENT.register(this::onFTBCacheClear);
    }

    public void betterOnCatch(PokemonReceivedEvent event) {
        if (this.catchTasks == null) {
            this.catchTasks = ServerQuestFile.INSTANCE.collect(CatchTask.class);
        }
        if (this.tradeTasks == null) {
            this.tradeTasks = ServerQuestFile.INSTANCE.collect(TradeTask.class);
        }
        if (this.catchTasks.isEmpty() && this.tradeTasks.isEmpty()) {
            return;
        }
        TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData((Entity)event.getPlayer());
        Pokemon pokemon = event.getPokemon();
        if (event.getCause().equals("Trade")) {
            for (TradeTask task : this.tradeTasks) {
                if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.getQuest())) continue;
                task.tradePokemon(data, pokemon);
            }
        } else {
            for (CatchTask task : this.catchTasks) {
                if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.getQuest())) continue;
                if (event.getCause().equals("PokeBall")) {
                    task.catchPokemon(data, pokemon);
                    continue;
                }
                if (event.getCause().equals("Fossil")) {
                    task.onFossil(data, pokemon);
                    continue;
                }
                if (event.getCause().equals("Christmas")) {
                    task.onChristmas(data, pokemon);
                    continue;
                }
                if (!event.getCause().equals("Command") && !event.getCause().equals("GiftCommand")) continue;
                task.onCommand(data, pokemon);
            }
        }
    }

    public void onRaidCatch(CaptureEvent.SuccessfulRaidCapture event) {
        if (this.catchTasks == null) {
            this.catchTasks = ServerQuestFile.INSTANCE.collect(CatchTask.class);
        }
        if (this.catchTasks.isEmpty()) {
            return;
        }
        TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData((Entity)event.getPlayer());
        Pokemon pokemon = event.getRaidPokemon();
        pokemon.setOriginalTrainer((Player)event.getPlayer());
        for (CatchTask task : this.catchTasks) {
            if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.getQuest())) continue;
            task.catchRaidPokemon(data, pokemon);
        }
    }

    public void onDefeatPokemon(AttackEvent.Damage event) {
        if (!event.willBeFatal()) {
            return;
        }
        if (this.defeatTasks == null) {
            this.defeatTasks = ServerQuestFile.INSTANCE.collect(DefeatTask.class);
        }
        if (this.defeatTasks.isEmpty()) {
            return;
        }
        HashSet<TeamData> teamsInBattle = new HashSet<TeamData>();
        PixelmonWrapper wrapper = event.target;
        BattleController controller = event.getBattleController();
        if (controller.getStage() == BattleStage.PICKACTION || wrapper.getEntity() == null) {
            return;
        }
        for (PixelmonWrapper opponent : controller.getOpponentPokemon(wrapper)) {
            TeamData data;
            if (opponent.getPlayerOwner() == null || teamsInBattle.contains(data = ServerQuestFile.INSTANCE.getOrCreateTeamData((Entity)opponent.getPlayerOwner()))) continue;
            teamsInBattle.add(data);
            for (DefeatTask task : this.defeatTasks) {
                if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.getQuest())) continue;
                task.defeatPokemon(data, wrapper.getEntity(), event.user.getEntity());
            }
        }
    }

    public void onBalanceSet(EconomyEvent.SetBalance event) {
        this.moneyThing((EconomyEvent)event);
    }

    public void onBalanceChange(EconomyEvent.PostTransaction event) {
        this.moneyThing((EconomyEvent)event);
    }

    private void moneyThing(EconomyEvent event) {
        if (this.antiOverflow.contains(event.getPlayer().getUUID())) {
            return;
        }
        TaskUtils.runLater(1, () -> {
            if (this.pokeDollarsTasks == null) {
                this.pokeDollarsTasks = ServerQuestFile.INSTANCE.collect(PokeDollarsTask.class);
            }
            if (this.pokeDollarsTasks.isEmpty()) {
                return;
            }
            TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData((Entity)event.getPlayer());
            this.antiOverflow.add(event.getPlayer().getUUID());
            TaskUtils.runLater(2, () -> this.antiOverflow.remove(event.getPlayer().getUUID()));
            for (PokeDollarsTask task : this.pokeDollarsTasks) {
                if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.getQuest())) continue;
                task.updateMoney(data, event.getPlayer());
            }
        });
    }

    public void onEvolve(EvolveEvent.Post event) {
        if (this.evolutionTasks == null) {
            this.evolutionTasks = ServerQuestFile.INSTANCE.collect(EvolutionTask.class);
        }
        if (this.evolutionTasks.isEmpty()) {
            return;
        }
        TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData((Entity)event.getPlayer());
        for (EvolutionTask task : this.evolutionTasks) {
            if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.getQuest())) continue;
            task.evolvePokemon(data, event.getPlayer(), event.getPokemon(), event.getEvolution());
        }
    }

    public void onHatch(EggHatchEvent.Post event) {
        if (this.hatchCommandFix.contains(event.getPokemon().getUUID())) {
            return;
        }
        if (this.hatchTasks == null) {
            this.hatchTasks = ServerQuestFile.INSTANCE.collect(HatchTask.class);
        }
        if (this.catchTasks == null) {
            this.catchTasks = ServerQuestFile.INSTANCE.collect(CatchTask.class);
        }
        if (this.hatchTasks.isEmpty() && this.catchTasks.isEmpty()) {
            return;
        }
        TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData((Entity)event.getPlayer());
        for (HatchTask hatchTask : this.hatchTasks) {
            if (data.getProgress((Task)hatchTask) >= hatchTask.getMaxProgress() || !data.canStartTasks(hatchTask.getQuest())) continue;
            hatchTask.onHatch(data, event.getPokemon());
        }
        for (CatchTask catchTask : this.catchTasks) {
            if (data.getProgress((Task)catchTask) >= catchTask.getMaxProgress() || !data.canStartTasks(catchTask.getQuest())) continue;
            catchTask.onEggHatch(data, event.getPokemon());
        }
        this.hatchCommandFix.add(event.getPokemon().getUUID());
        TaskUtils.runLater(1, () -> this.hatchCommandFix.remove(event.getPokemon().getUUID()));
    }

    public void onBreed(DayCareEvent.PostCollect event) {
        if (this.breedTasks == null) {
            this.breedTasks = ServerQuestFile.INSTANCE.collect(BreedTask.class);
        }
        if (this.breedTasks.isEmpty()) {
            return;
        }
        TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData((Entity)event.getPlayer());
        for (BreedTask task : this.breedTasks) {
            if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.getQuest())) continue;
            task.onBreed(data, event.getParentOne(), event.getParentTwo());
        }
    }

    private void updatePokedex(ServerPlayer player) {
        if (this.pokedexTasks == null) {
            this.pokedexTasks = new ArrayList<PokedexTask>();
            this.pokedexTasks.addAll(ServerQuestFile.INSTANCE.collect(PokedexPercentageTask.class));
            this.pokedexTasks.addAll(ServerQuestFile.INSTANCE.collect(PokedexAmountTask.class));
        }
        if (this.pokedexTasks.isEmpty()) {
            return;
        }
        TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData((Entity)player);
        for (PokedexTask task : this.pokedexTasks) {
            if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.getQuest())) continue;
            task.updatePokedex(data, player);
        }
    }

    public void onPokedexUpdate(PokedexEvent.Post event) {
        this.updatePokedex(event.getPlayer());
    }

    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            this.updatePokedex((ServerPlayer)event.getEntity());
        }
    }

    public void onLevelUp(LevelUpEvent.Post event) {
        if (this.levelTasks == null) {
            this.levelTasks = ServerQuestFile.INSTANCE.collect(LevelTask.class);
        }
        if (this.levelTasks.isEmpty()) {
            return;
        }
        TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData((Entity)event.getPlayer());
        for (LevelTask task : this.levelTasks) {
            if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.getQuest())) continue;
            task.onLevel(data, event.getPokemon(), event.getCause());
        }
    }

    public void onWipeout(BattleEndEvent event) {
        if (this.wipeoutTasks == null) {
            this.wipeoutTasks = ServerQuestFile.INSTANCE.collect(WipeoutTask.class);
        }
        if (this.defeatPlayersTasks == null) {
            this.defeatPlayersTasks = ServerQuestFile.INSTANCE.collect(DefeatPlayersTask.class);
        }
        if (this.defeatTrainerTasks == null) {
            this.defeatTrainerTasks = ServerQuestFile.INSTANCE.collect(DefeatTrainerTask.class);
        }
        if (this.wipeoutTasks.isEmpty() && this.defeatPlayersTasks.isEmpty() && this.defeatTrainerTasks.isEmpty()) {
            return;
        }
        if (event.getBattleController().isRaid() || event.getBattleController().isSimulation() || event.getBattleController().getPlayers().isEmpty()) {
            return;
        }
        boolean pvp = event.getBattleController().isPvP();
        boolean trainer = event.getBattleController().participants.stream().anyMatch(p -> {
            EntityParticipant pe;
            return p instanceof EntityParticipant && (pe = (EntityParticipant)p).isTrainer() && pe.getEntity() instanceof NPC;
        });
        for (Map.Entry entry : event.getResults().entrySet()) {
            if (!(entry.getKey() instanceof PlayerParticipant)) continue;
            ServerPlayer player = ((PlayerParticipant)entry.getKey()).player;
            TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData((Entity)player);
            if (entry.getValue() == BattleResults.DEFEAT) {
                for (Object task : this.wipeoutTasks) {
                    if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.getQuest())) continue;
                    task.onWipeout(data, player);
                }
                continue;
            }
            if (entry.getValue() != BattleResults.VICTORY) continue;
            if (pvp) {
                Object task;
                Player other = event.getPlayers().stream().filter(p -> p != player).findFirst().get();
                if (!(other instanceof ServerPlayer)) {
                    PixelTweaks.LOGGER.warn("PVP battle ended with non-server player: " + other.getName().getString());
                    return;
                }
                task = this.defeatPlayersTasks.iterator();
                while (task.hasNext()) {
                    DefeatPlayersTask task2 = (DefeatPlayersTask)((Object)task.next());
                    if (data.getProgress((Task)task2) >= task2.getMaxProgress() || !data.canStartTasks(task2.getQuest())) continue;
                    task2.onDefeat(data, (ServerPlayer)other);
                }
                continue;
            }
            if (!trainer) continue;
            EntityParticipant participant = (EntityParticipant)event.getBattleController().participants.stream().filter(p -> {
                if (!(p instanceof EntityParticipant)) return false;
                EntityParticipant ep = (EntityParticipant)p;
                if (!p.isTrainer()) return false;
                return true;
            }).findFirst().get();
            NPC trainerNPC = (NPC)participant.getEntity();
            for (DefeatTrainerTask task : this.defeatTrainerTasks) {
                if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.getQuest())) continue;
                task.defeatTrainer(data, trainerNPC);
            }
        }
    }

    public void onBattleMove(AttackEvent.CriticalHit event) {
        if (this.battleMoveFix.contains(event.getAttack())) {
            this.battleMoveFix.remove(event.getAttack());
            return;
        }
        this.battleMoveFix.add(event.getAttack());
        if (this.battleMoveTasks == null) {
            this.battleMoveTasks = ServerQuestFile.INSTANCE.collect(BattleMoveTask.class);
        }
        if (this.battleMoveTasks.isEmpty()) {
            return;
        }
        if (event.user.getPlayerOwner() == null) {
            return;
        }
        TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData((Entity)event.user.getPlayerOwner());
        for (BattleMoveTask task : this.battleMoveTasks) {
            if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.getQuest())) continue;
            PixelTweaks.LOGGER.debug("Battle move task for move: " + event.getAttack().getMove().getAttackName());
            task.onBattleMove(data, event.user.getOriginalPokemon(), event.getAttack());
        }
    }

    public void onTakePhoto(CameraEvent.TakePhoto event) {
        if (this.photoTasks == null) {
            this.photoTasks = ServerQuestFile.INSTANCE.collect(PhotoTask.class);
        }
        if (this.photoTasks.isEmpty()) {
            return;
        }
        TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData((Entity)event.player);
        for (PhotoTask task : this.photoTasks) {
            if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.getQuest())) continue;
            task.takePhoto(data, event.pixelmon);
        }
    }

    public void onExternalMove(UseMoveSkillEvent event) {
        if (this.externalMoveTasks == null) {
            this.externalMoveTasks = ServerQuestFile.INSTANCE.collect(ExternalMoveTask.class);
        }
        if (this.externalMoveTasks.isEmpty()) {
            return;
        }
        if (event.pixelmon.getOwner() instanceof ServerPlayer) {
            TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData((Entity)event.pixelmon.getOwner());
            for (ExternalMoveTask task : this.externalMoveTasks) {
                if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.getQuest())) continue;
                task.onMove(data, event.moveSkill.id(), event.pixelmon.getPokemon());
            }
        }
    }

    public void onPokemonRelease(PixelmonDeletedEvent event) {
        if (event.deleteType == DeleteType.PC) {
            if (this.releaseTasks == null) {
                this.releaseTasks = ServerQuestFile.INSTANCE.collect(ReleaseTask.class);
            }
            if (this.releaseTasks.isEmpty()) {
                return;
            }
            TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData((Entity)event.player);
            for (ReleaseTask task : this.releaseTasks) {
                if (data.getProgress((Task)task) >= task.getMaxProgress() || !data.canStartTasks(task.getQuest())) continue;
                task.releasePokemon(data, event.player, event.pokemon);
            }
        }
    }

    private void onFTBCacheClear(BaseQuestFile event) {
        if (event.isServerSide()) {
            this.catchTasks = null;
            this.defeatPlayersTasks = null;
            this.defeatTasks = null;
            this.defeatTrainerTasks = null;
            this.battleMoveTasks = null;
            this.externalMoveTasks = null;
            this.evolutionTasks = null;
            this.levelTasks = null;
            this.photoTasks = null;
            this.wipeoutTasks = null;
            this.pokedexTasks = null;
            this.breedTasks = null;
            this.hatchTasks = null;
            this.tradeTasks = null;
            this.pokeDollarsTasks = null;
            this.releaseTasks = null;
        }
    }
}

