/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.integration.ftbquests.rewards;

import com.pixelmonmod.pixelmon.api.economy.BankAccountProxy;
import com.strangeone101.pixeltweaks.integration.ftbquests.PokemonRewardTypes;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftbquests.net.DisplayRewardToastMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PokeDollarReward
extends Reward {
    public int count = 100;

    public PokeDollarReward(long id, Quest q) {
        super(id, q);
    }

    public RewardType getType() {
        return PokemonRewardTypes.POKEDOLLARS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addInt("count", this.count, v -> {
            this.count = v;
        }, 1, 1, Integer.MAX_VALUE);
    }

    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putInt("count", this.count);
    }

    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.count = nbt.getInt("count");
    }

    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.count = buffer.readVarInt();
    }

    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeVarInt(this.count);
    }

    public void claim(ServerPlayer ServerPlayer2, boolean b) {
        BankAccountProxy.getBankAccountNow((ServerPlayer)ServerPlayer2).add(this.count);
        NetworkManager.sendToPlayer((ServerPlayer)ServerPlayer2, (CustomPacketPayload)new DisplayRewardToastMessage(this.id, (Component)Component.translatable((String)"ftbquests.reward.pixelmon.pokedollars.toast", (Object[])new Object[]{this.count}), Icon.getIcon((String)"pixelmon:textures/gui/pokedollar.png"), true));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getAltTitle() {
        return Component.literal((String)(StringUtils.formatDouble((double)this.count, (boolean)true) + " ")).append(this.getType().getDisplayName());
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getButtonText() {
        return this.count > 1 ? StringUtils.formatDouble((double)this.count, (boolean)true) : "";
    }
}

