/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.integration.ftbquests.rewards;

import com.mojang.datafixers.util.Pair;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.pokemon.requirement.impl.FormRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.GenderRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.GenerationRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.LegendaryRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.PaletteRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.ShinyRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.TypeRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.UltraBeastRequirement;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.strangeone101.pixeltweaks.PixelTweaks;
import com.strangeone101.pixeltweaks.integration.ftbquests.PokemonConfig;
import com.strangeone101.pixeltweaks.integration.ftbquests.PokemonRewardTypes;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconAnimation;
import dev.ftb.mods.ftbquests.net.DisplayRewardToastMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PokemonReward
extends Reward {
    public transient PokemonSpecification cachedSpec;
    public int count = 1;
    public short shinyChance = (short)4096;

    public PokemonReward(long id, Quest q) {
        super(id, q);
    }

    public RewardType getType() {
        return PokemonRewardTypes.POKEMON;
    }

    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putString("spec", this.cachedSpec == null ? "" : this.cachedSpec.toString());
        nbt.putInt("count", this.count);
        nbt.putShort("shinyChance", this.shinyChance);
    }

    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        String spec = nbt.getString("spec");
        this.cachedSpec = spec.isEmpty() ? null : (PokemonSpecification)PokemonSpecificationProxy.create((String[])new String[]{spec}).get();
        this.count = nbt.getInt("count");
        this.shinyChance = nbt.getShort("shinyChance");
    }

    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeUtf(this.cachedSpec == null ? "" : this.cachedSpec.toString());
        buffer.writeVarInt(this.count);
        buffer.writeVarInt((int)this.shinyChance);
    }

    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        String spec = buffer.readUtf();
        this.cachedSpec = spec.isEmpty() ? null : (PokemonSpecification)PokemonSpecificationProxy.create((String[])new String[]{spec}).get();
        this.count = buffer.readVarInt();
        this.shinyChance = (short)buffer.readVarInt();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.add("spec", (ConfigValue)new PokemonConfig(true), (Object)this.cachedSpec, v -> {
            this.cachedSpec = v;
        }, (Object)((PokemonSpecification)PokemonSpecificationProxy.create((String[])new String[]{"random"}).get()));
        config.addInt("count", this.count, v -> {
            this.count = v;
        }, 1, 1, Integer.MAX_VALUE);
        config.addInt("shinyChance", (int)this.shinyChance, v -> {
            this.shinyChance = v.shortValue();
        }, 4096, 0, Short.MAX_VALUE);
    }

    public void claim(ServerPlayer player, boolean notify) {
        for (int c = this.count; c > 0; --c) {
            Pokemon pokemon = this.cachedSpec.create();
            if (this.shinyChance > 0 && player.getRandom().nextInt((int)this.shinyChance) == 0 && (pokemon.getPalette().is("none") || pokemon.getPalette().is(""))) {
                pokemon.setShiny(true);
            }
            if (notify) {
                NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new DisplayRewardToastMessage(this.id, (Component)Component.translatable((String)"ftbquests.reward.pixelmon.pokemon.toast", (Object[])new Object[]{this.getPokemon()}), Icon.getIcon((ResourceLocation)pokemon.getSprite()), true));
            }
            try {
                if (!((PlayerPartyStorage)StorageProxy.getParty((Player)player).get()).add(pokemon)) {
                    PixelTweaks.LOGGER.warn("Failed to add pokemon to player's party! Storage full! Reward ID: " + this.id + ", Pokemon: " + String.valueOf(pokemon.getDisplayName()));
                }
            }
            catch (Exception e) {
                PixelTweaks.LOGGER.error("Failed to add pokemon to player's party! Storage could not be gotten!");
                e.printStackTrace();
            }
            this.cachedSpec = (PokemonSpecification)PokemonSpecificationProxy.create((String[])new String[]{this.cachedSpec.toString()}).get();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        if (this.cachedSpec != null && this.cachedSpec.getValue(SpeciesRequirement.class).isPresent() && this.cachedSpec != null && !this.cachedSpec.toString().split(" ")[0].equalsIgnoreCase("random")) {
            return Icon.getIcon((ResourceLocation)this.cachedSpec.create().getSprite());
        }
        int randomMon = 100;
        ArrayList<Icon> icons = new ArrayList<Icon>();
        for (int i = 0; i < randomMon; ++i) {
            Pokemon pokemon = this.cachedSpec.create();
            if (pokemon.getSprite() == null || pokemon.getSprite().getPath().isEmpty()) continue;
            icons.add(Icon.getIcon((ResourceLocation)pokemon.getSprite()));
        }
        return IconAnimation.fromList(icons, (boolean)false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getAltTitle() {
        return this.getPokemon();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getButtonText() {
        return this.count > 1 ? "" + this.count : "";
    }

    protected Component getPokemon() {
        MutableComponent form;
        MutableComponent pokemon = Component.translatable((String)"pixeltweaks.lang.pokemon");
        if (this.cachedSpec == null) {
            return pokemon;
        }
        ArrayList<MutableComponent> componentList = new ArrayList<MutableComponent>();
        if (this.cachedSpec.getValue(SpeciesRequirement.class).isPresent() && this.cachedSpec != null && !this.cachedSpec.toString().split(" ")[0].equalsIgnoreCase("random")) {
            MutableComponent species = Component.translatable((String)("pixelmon." + ((RegistryValue)this.cachedSpec.getValue(SpeciesRequirement.class).get()).getKey().toLowerCase()));
            componentList.add(species);
        } else {
            MutableComponent nonText;
            if (this.cachedSpec.getValue(LegendaryRequirement.class).isPresent()) {
                boolean legend = (Boolean)this.cachedSpec.getValue(LegendaryRequirement.class).get();
                if (!legend) {
                    legendText = Component.translatable((String)"pixeltweaks.lang.legendary");
                    nonText = Component.translatable((String)"pixeltweaks.lang.not", (Object[])new Object[]{legendText});
                    componentList.add(nonText);
                } else {
                    legendText = Component.translatable((String)"pixeltweaks.lang.legendary");
                    componentList.add(legendText);
                }
            }
            if (this.cachedSpec.getValue(UltraBeastRequirement.class).isPresent()) {
                boolean ultra = (Boolean)this.cachedSpec.getValue(UltraBeastRequirement.class).get();
                if (!ultra) {
                    ultraText = Component.translatable((String)"pixeltweaks.lang.ultrabeast");
                    nonText = Component.translatable((String)"pixeltweaks.lang.not", (Object[])new Object[]{ultraText});
                    componentList.add(nonText);
                } else {
                    ultraText = Component.translatable((String)"pixeltweaks.lang.ultrabeast");
                    componentList.add(ultraText);
                }
            }
            if (this.cachedSpec.getValue(GenerationRequirement.class).isPresent()) {
                MutableComponent newType = Component.translatable((String)"pixeltweaks.lang.generation", (Object[])new Object[]{(int)((Integer)this.cachedSpec.getValue(GenerationRequirement.class).get())});
                componentList.add(newType);
            }
            if (this.cachedSpec.getValue(TypeRequirement.class).isPresent()) {
                MutableComponent type = Component.translatable((String)("type." + ((ResourceKey)((Pair)this.cachedSpec.getValue(TypeRequirement.class).get()).getSecond()).location().toString().toLowerCase()));
                MutableComponent newType = Component.translatable((String)"pixeltweaks.lang.type", (Object[])new Object[]{type});
                componentList.add(newType);
            }
            componentList.add(0, pokemon);
        }
        if (this.cachedSpec.getValue(FormRequirement.class).isPresent()) {
            form = Component.translatable((String)("pixelmon.generic.form." + ((String)this.cachedSpec.getValue(FormRequirement.class).get()).toLowerCase()));
            componentList.add(form);
        }
        if (this.cachedSpec.getValue(PaletteRequirement.class).isPresent()) {
            form = Component.translatable((String)("pixelmon.palette." + ((String)this.cachedSpec.getValue(PaletteRequirement.class).get()).toLowerCase()));
            componentList.add(form);
        }
        if (this.cachedSpec.getValue(GenderRequirement.class).isPresent()) {
            MutableComponent gender = Component.translatable((String)((Gender)this.cachedSpec.getValue(GenderRequirement.class).get()).getTranslationKey());
            componentList.add(gender);
        }
        if (this.cachedSpec.getValue(ShinyRequirement.class).isPresent() || Arrays.asList(this.cachedSpec.toString().toLowerCase().split(" ")).contains("shiny")) {
            MutableComponent shiny = Component.translatable((String)"pixelmon.palette.shiny");
            componentList.add(shiny);
        }
        if (this.cachedSpec != null && this.cachedSpec.toString().split(" ")[0].equalsIgnoreCase("random")) {
            MutableComponent random = Component.translatable((String)"pixeltweaks.lang.random");
            componentList.add(random);
        }
        MutableComponent all = Component.literal((String)"");
        for (int i = componentList.size() - 1; i >= 0; --i) {
            all.append((Component)componentList.get(i));
            if (i == 0) continue;
            all.append(" ");
        }
        return all;
    }
}

