/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.integration.ftbquests.tasks;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.strangeone101.pixeltweaks.integration.ftbquests.PokemonTask;
import com.strangeone101.pixeltweaks.integration.ftbquests.PokemonTaskTypes;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BattleMoveTask
extends PokemonTask {
    public String attack = "";
    public Tristate crit = Tristate.DEFAULT;
    public MoveType moveType = MoveType.ANY;

    public BattleMoveTask(long id, Quest q) {
        super(id, q);
    }

    public TaskType getType() {
        return PokemonTaskTypes.BATTLE_MOVE;
    }

    @Override
    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putString("attack", this.attack);
        this.crit.write(nbt, "crit");
        nbt.putByte("moveType", (byte)this.moveType.ordinal());
    }

    @Override
    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.attack = nbt.getString("attack");
        this.crit = Tristate.read((CompoundTag)nbt, (String)"crit");
        this.moveType = MoveType.values()[nbt.getByte("moveType")];
    }

    @Override
    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeUtf(this.attack);
        this.crit.write((FriendlyByteBuf)buffer);
        buffer.writeByte(this.moveType.ordinal());
    }

    @Override
    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.attack = buffer.readUtf();
        this.crit = Tristate.read((FriendlyByteBuf)buffer);
        this.moveType = MoveType.values()[buffer.readByte()];
    }

    @Override
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addString("attack", this.attack, v -> {
            this.attack = v.toLowerCase().replace(' ', '_');
        }, "");
        config.addTristate("crit", this.crit, v -> {
            this.crit = v;
        }, Tristate.DEFAULT);
        config.addEnum("moveType", (Object)this.moveType, v -> {
            this.moveType = v;
        }, NameMap.of((Object)((Object)MoveType.ANY), (Object[])MoveType.values()).nameKey(v -> "pixeltweaks.battle_move_type." + v.toString().toLowerCase()).create());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Component getAltTitle() {
        MutableComponent title = Component.translatable((String)"ftbquests.task.pixelmon.battle_move.title", (Object[])new Object[]{Component.translatable((String)("attack." + this.attack)), Component.literal((String)(this.count > 1 ? " x" + this.count : ""))});
        if (this.attack.isEmpty()) {
            title = Component.translatable((String)"ftbquests.task.pixelmon.battle_move");
        }
        if (this.cachedSpec != null) {
            title = Component.translatable((String)"ftbquests.task.pixelmon.battle_move.title_specific", (Object[])new Object[]{Component.translatable((String)("attack." + this.attack)), Component.literal((String)(this.count > 1 ? " x" + this.count : "")), this.getPokemon()});
        }
        return title;
    }

    public void onBattleMove(TeamData team, Pokemon pokemon, Attack move) {
        if (!(team.isCompleted((QuestObject)this) || this.cachedSpec != null && !this.cachedSpec.matches((Object)pokemon) || !this.attack.isEmpty() && !this.attack.equalsIgnoreCase(move.getMove().getAttackName().toLowerCase().replace(' ', '_')) || this.crit != Tristate.DEFAULT && this.crit.isTrue() != move.didCrit || this.moveType != MoveType.ANY && !(move.isMax ? this.moveType == MoveType.DYNAMAX : (move.isZ ? this.moveType == MoveType.Z_MOVE : this.moveType == MoveType.NORMAL)))) {
            team.addProgress((Task)this, 1L);
        }
    }

    public static enum MoveType {
        ANY,
        NORMAL,
        Z_MOVE,
        DYNAMAX;

    }
}

