/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.integration.ftbquests.tasks;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.strangeone101.pixeltweaks.integration.ftbquests.PokemonConfig;
import com.strangeone101.pixeltweaks.integration.ftbquests.PokemonTaskTypes;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BreedTask
extends Task {
    public int count = 1;
    public transient PokemonSpecification parent1;
    public transient PokemonSpecification parent2;

    public BreedTask(long id, Quest q) {
        super(id, q);
    }

    public TaskType getType() {
        return PokemonTaskTypes.BREED_POKEMON;
    }

    public long getMaxProgress() {
        return this.count;
    }

    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putString("parent1", this.parent1 == null ? "" : this.parent1.toString());
        nbt.putString("parent2", this.parent2 == null ? "" : this.parent2.toString());
        nbt.putInt("count", this.count);
    }

    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        String parent1Specs = nbt.getString("parent1");
        this.parent1 = parent1Specs.isEmpty() ? null : (PokemonSpecification)PokemonSpecificationProxy.create((String[])new String[]{parent1Specs}).get();
        String parent2Specs = nbt.getString("parent2");
        this.parent2 = parent2Specs.isEmpty() ? null : (PokemonSpecification)PokemonSpecificationProxy.create((String[])new String[]{parent2Specs}).get();
        this.count = nbt.getInt("count");
    }

    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeUtf(this.parent1 == null ? "" : this.parent1.toString());
        buffer.writeUtf(this.parent2 == null ? "" : this.parent2.toString());
        buffer.writeVarInt(this.count);
    }

    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        String parent1Specs = buffer.readUtf();
        this.parent1 = parent1Specs.isEmpty() ? null : (PokemonSpecification)PokemonSpecificationProxy.create((String[])new String[]{parent1Specs}).get();
        String parent2Specs = buffer.readUtf();
        this.parent2 = parent2Specs.isEmpty() ? null : (PokemonSpecification)PokemonSpecificationProxy.create((String[])new String[]{parent2Specs}).get();
        this.count = buffer.readVarInt();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.add("parent1", (ConfigValue)new PokemonConfig(false), (Object)this.parent1, v -> {
            this.parent1 = v;
        }, null);
        config.add("parent2", (ConfigValue)new PokemonConfig(false), (Object)this.parent2, v -> {
            this.parent2 = v;
        }, null);
        config.addInt("count", this.count, v -> {
            this.count = v;
        }, 1, 1, Integer.MAX_VALUE);
    }

    public void onBreed(TeamData data, Pokemon parentOne, Pokemon parentTwo) {
        if (data.isCompleted((QuestObject)this)) {
            return;
        }
        if (this.parent1 != null && this.parent2 != null) {
            if (this.parent1.matches((Object)parentOne) && this.parent2.matches((Object)parentTwo)) {
                data.addProgress((Task)this, 1L);
            } else if (this.parent1.matches((Object)parentTwo) && this.parent2.matches((Object)parentOne)) {
                data.addProgress((Task)this, 1L);
            }
        } else if (this.parent1 != null) {
            if (this.parent1.matches((Object)parentOne) || this.parent1.matches((Object)parentTwo)) {
                data.addProgress((Task)this, 1L);
            }
        } else if (this.parent2 != null) {
            if (this.parent2.matches((Object)parentOne) || this.parent2.matches((Object)parentTwo)) {
                data.addProgress((Task)this, 1L);
            }
        } else {
            data.addProgress((Task)this, 1L);
        }
    }
}

