/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.integration.ftbquests.tasks;

import com.pixelmonmod.pixelmon.entities.npcs.NPC;
import com.strangeone101.pixeltweaks.integration.ftbquests.PokemonTaskTypes;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class DefeatTrainerTask
extends Task {
    public int count = 1;
    @Deprecated
    public Tristate gymLeader = Tristate.DEFAULT;
    @Deprecated
    public String bossTier = "";
    public String customName;
    public transient Component customNameCache;
    public UUID trainerUUID;

    public DefeatTrainerTask(long id, Quest q) {
        super(id, q);
    }

    public TaskType getType() {
        return PokemonTaskTypes.DEFEAT_TRAINER;
    }

    public long getMaxProgress() {
        return this.count;
    }

    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putInt("count", this.count);
        nbt.putString("customName", this.customName == null ? "" : this.customName);
        nbt.putString("trainerUUID", this.trainerUUID == null ? "" : this.trainerUUID.toString());
    }

    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.count = nbt.getInt("count");
        this.customName = nbt.getString("customName");
        this.recalculateNameCache();
        String uuidString = nbt.getString("trainerUUID");
        if (!uuidString.isEmpty()) {
            this.trainerUUID = UUID.fromString(uuidString);
        }
    }

    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeVarInt(this.count);
        buffer.writeUtf(this.customName == null ? "" : this.customName);
        buffer.writeUtf(this.trainerUUID == null ? "" : this.trainerUUID.toString());
    }

    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.count = buffer.readVarInt();
        this.customName = buffer.readUtf();
        this.recalculateNameCache();
        String uuidString = buffer.readUtf();
        if (!uuidString.isEmpty()) {
            this.trainerUUID = UUID.fromString(uuidString);
        }
    }

    public void recalculateNameCache() {
        this.customNameCache = this.customName != null && !this.customName.isEmpty() ? (this.customName.startsWith("pixelmon.") || this.customName.startsWith("minecraft.") ? Component.translatable((String)this.customName) : Component.literal((String)this.customName)) : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addInt("count", this.count, v -> {
            this.count = v;
        }, 1, 1, Integer.MAX_VALUE);
        config.addString("customName", this.customName, v -> {
            this.customName = v;
            this.recalculateNameCache();
        }, "");
        config.addString("trainerUUID", this.trainerUUID == null ? "" : this.trainerUUID.toString(), v -> {
            this.trainerUUID = v.isEmpty() ? null : UUID.fromString(v);
        }, "");
    }

    public void defeatTrainer(TeamData team, NPC trainer) {
        if (!team.isCompleted((QuestObject)this) && team.getFile().isServerSide()) {
            if (this.customNameCache == null != trainer.hasCustomName()) {
                return;
            }
            if (this.customNameCache != null && !this.customNameCache.equals((Object)trainer.getCustomName())) {
                return;
            }
            if (this.trainerUUID != null && !trainer.getUUID().equals(this.trainerUUID)) {
                return;
            }
            team.addProgress((Task)this, 1L);
        }
    }
}

