/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.integration.ftbquests.tasks;

import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.strangeone101.pixeltweaks.integration.ftbquests.PokemonTask;
import com.strangeone101.pixeltweaks.integration.ftbquests.PokemonTaskTypes;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ExternalMoveTask
extends PokemonTask {
    public String move = "forage";

    public ExternalMoveTask(long id, Quest q) {
        super(id, q);
    }

    @Override
    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putString("move", this.move);
    }

    @Override
    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.move = nbt.getString("move");
    }

    @Override
    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeUtf(this.move);
    }

    @Override
    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.move = buffer.readUtf();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addEnum("move", (Object)this.move, v -> {
            this.move = v;
        }, NameMap.of((Object)"forage", MoveSkill.getAllMoveSkills().stream().map(m -> m.id()).collect(Collectors.toList())).nameKey(m -> "pixelmon.moveskill." + m).icon(m -> Icon.getIcon((ResourceLocation)MoveSkill.getMoveSkillByID((String)m).sprite())).create());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        return Icon.getIcon((ResourceLocation)MoveSkill.getMoveSkillByID((String)this.move).sprite());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Component getAltTitle() {
        MutableComponent title = Component.translatable((String)"ftbquests.task.pixelmon.external_move.title", (Object[])new Object[]{Component.translatable((String)MoveSkill.getMoveSkillByID((String)this.move).name())});
        if (this.count > 1) {
            title.append(" ");
            title.append(this.count + "x");
        }
        if (this.cachedSpec != null) {
            title.append(" ");
            title.append(this.getPokemon());
        }
        return title;
    }

    public TaskType getType() {
        return PokemonTaskTypes.EXTERNAL_MOVE;
    }

    public void onMove(TeamData teamData, String move, Pokemon pokemon) {
        if (teamData.isCompleted((QuestObject)this)) {
            return;
        }
        if (teamData.getFile().isServerSide() && (this.cachedSpec == null || this.cachedSpec.matches((Object)pokemon) != this.invert) && this.move.equals(move)) {
            teamData.addProgress((Task)this, 1L);
        }
    }
}

