/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.integration.ftbquests.tasks;

import com.pixelmonmod.pixelmon.api.enums.ExperienceGainType;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.strangeone101.pixeltweaks.integration.ftbquests.PokemonTask;
import com.strangeone101.pixeltweaks.integration.ftbquests.PokemonTaskTypes;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class LevelTask
extends PokemonTask {
    public ExperienceCause cause = ExperienceCause.ANY;

    public LevelTask(long id, Quest q) {
        super(id, q);
    }

    public TaskType getType() {
        return PokemonTaskTypes.LEVEL_POKEMON;
    }

    @Override
    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putByte("cause", (byte)this.cause.ordinal());
    }

    @Override
    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.cause = ExperienceCause.values()[nbt.getByte("cause")];
    }

    @Override
    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeByte(this.cause.ordinal());
    }

    @Override
    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.cause = ExperienceCause.values()[buffer.readByte()];
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addEnum("cause", (Object)this.cause, v -> {
            this.cause = v;
        }, NameMap.of((Object)((Object)ExperienceCause.ANY), (Object[])ExperienceCause.values()).nameKey(exc -> "pixeltweaks.level_up_cause." + exc.name().toLowerCase()).create());
    }

    public void onLevel(TeamData team, Pokemon pokemon, ExperienceGainType cause) {
        if (!team.isCompleted((QuestObject)this) && team.getFile().isServerSide() && this.cause.matches(cause) && (this.cachedSpec == null || this.cachedSpec.matches((Object)pokemon) != this.invert)) {
            team.addProgress((Task)this, 1L);
        }
    }

    public static enum ExperienceCause {
        ANY(ExperienceGainType.values()),
        BATTLE(ExperienceGainType.BATTLE),
        RARE_CANDY(ExperienceGainType.RARE_CANDY),
        EXP_CANDY(ExperienceGainType.SMALL_EXP_CANDY, ExperienceGainType.MEDIUM_EXP_CANDY, ExperienceGainType.LARGE_EXP_CANDY, ExperienceGainType.EXTRA_LARGE_EXP_CANDY, ExperienceGainType.EXTRA_SMALL_EXP_CANDY),
        ALL_CANDIES(ExperienceGainType.RARE_CANDY, ExperienceGainType.SMALL_EXP_CANDY, ExperienceGainType.MEDIUM_EXP_CANDY, ExperienceGainType.LARGE_EXP_CANDY, ExperienceGainType.EXTRA_LARGE_EXP_CANDY, ExperienceGainType.EXTRA_SMALL_EXP_CANDY),
        SODA(ExperienceGainType.RARE_SODA, ExperienceGainType.ULTRA_RARE_SODA),
        ALL_ITEMS(ExperienceGainType.RARE_CANDY, ExperienceGainType.RARE_SODA, ExperienceGainType.ULTRA_RARE_SODA, ExperienceGainType.SMALL_EXP_CANDY, ExperienceGainType.MEDIUM_EXP_CANDY, ExperienceGainType.LARGE_EXP_CANDY, ExperienceGainType.EXTRA_LARGE_EXP_CANDY, ExperienceGainType.EXTRA_SMALL_EXP_CANDY),
        CURRY(ExperienceGainType.CURRY_CHARIZARD, ExperienceGainType.CURRY_WOBBUFFET, ExperienceGainType.CURRY_KOFFING, ExperienceGainType.CURRY_COPPERAJAH, ExperienceGainType.CURRY_MILCERY);

        private final ExperienceGainType[] internalCauses;

        private ExperienceCause(ExperienceGainType ... internalCauses) {
            this.internalCauses = internalCauses;
        }

        public boolean matches(ExperienceGainType type) {
            for (ExperienceGainType cause : this.internalCauses) {
                if (cause != type) continue;
                return true;
            }
            return false;
        }
    }
}

