/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.integration.ftbquests.tasks;

import com.pixelmonmod.pixelmon.api.economy.BankAccount;
import com.pixelmonmod.pixelmon.api.economy.BankAccountProxy;
import com.strangeone101.pixeltweaks.PixelTweaks;
import com.strangeone101.pixeltweaks.integration.ftbquests.PokemonTaskTypes;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PokeDollarsTask
extends Task {
    public int amount = 1000;
    public Tristate consumeMoney = Tristate.DEFAULT;

    public PokeDollarsTask(long id, Quest q) {
        super(id, q);
    }

    public TaskType getType() {
        return PokemonTaskTypes.POKEDOLLARS;
    }

    public long getMaxProgress() {
        return this.amount;
    }

    public boolean consumesResources() {
        return this.consumeMoney.get(this.getQuest().getChapter().file.isDefaultTeamConsumeItems());
    }

    public boolean canInsertItem() {
        return this.consumesResources();
    }

    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putInt("amount", this.amount);
        this.consumeMoney.write(nbt, "consumeMoney");
    }

    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.amount = nbt.getInt("amount");
        this.consumeMoney = Tristate.read((CompoundTag)nbt, (String)"consumeMoney");
    }

    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeVarInt(this.amount);
        this.consumeMoney.write((FriendlyByteBuf)buffer);
    }

    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.amount = buffer.readVarInt();
        this.consumeMoney = Tristate.read((FriendlyByteBuf)buffer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addInt("amount", this.amount, v -> {
            this.amount = v;
        }, 1, 1, Integer.MAX_VALUE);
        config.addTristate("consumeMoney", this.consumeMoney, v -> {
            this.consumeMoney = v;
        }, Tristate.DEFAULT);
    }

    public void submitTask(TeamData teamData, ServerPlayer player, ItemStack craftedItem) {
        if (teamData.isCompleted((QuestObject)this)) {
            return;
        }
        this.updateMoney(teamData, player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getAltTitle() {
        return Component.translatable((String)"ftbquests.task.pixelmon.pokedollars.title", (Object[])new Object[]{this.amount});
    }

    public void updateMoney(TeamData teamData, ServerPlayer player) {
        if (teamData.isCompleted((QuestObject)this) || BankAccountProxy.getBankAccount((ServerPlayer)player).getNow(null) == null) {
            return;
        }
        int m = ((BankAccount)BankAccountProxy.getBankAccount((ServerPlayer)player).getNow(null)).getBalance().intValue();
        if (m <= 0) {
            return;
        }
        PixelTweaks.LOGGER.debug("Player has " + m + " PokeDollars");
        boolean complete = m >= this.amount;
        int n = m = complete ? this.amount : m;
        if (teamData.getFile().isServerSide()) {
            teamData.setProgress((Task)this, (long)m);
            if (this.consumesResources() && complete) {
                ((BankAccount)BankAccountProxy.getBankAccount((ServerPlayer)player).getNow(null)).take(this.amount);
            }
        }
    }
}

