/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.integration.ftbquests.tasks;

import com.pixelmonmod.pixelmon.api.pokedex.PokeDexStorageProxy;
import com.pixelmonmod.pixelmon.api.pokedex.Pokedex;
import com.pixelmonmod.pixelmon.api.pokedex.Region;
import com.pixelmonmod.pixelmon.api.pokedex.status.PokedexRegistrationStatus;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.pokemon.type.Type;
import com.pixelmonmod.pixelmon.init.registry.PixelmonRegistry;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.neoforged.neoforgespi.Environment;

public abstract class PokedexTask
extends Task {
    public static final List<Integer> PARADOX = Arrays.asList(984, 985, 986, 987, 988, 989, 990, 991, 992, 993, 994, 995, 1005, 1006, 1009, 1010, 1020, 1021, 1022, 1023);
    protected transient Set<PokemonBase> filteredPokedex = new HashSet<PokemonBase>();
    protected transient long maxPokedexSize = 0L;
    public boolean caught = true;
    public PokedexFilter filter = PokedexFilter.ALL;
    public ResourceKey<Type> type = Type.MYSTERY;
    public ResourceKey<Region> region = null;
    public ResourceKey<Pokedex> pokedex = Pokedex.NATIONAL_DEX;

    public PokedexTask(long id, Quest q) {
        super(id, q);
    }

    public long getMaxProgress() {
        return this.maxPokedexSize;
    }

    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putByte("filter", (byte)this.filter.ordinal());
        nbt.putBoolean("caught", this.caught);
        nbt.putString("pokeType", this.type == null ? "" : this.type.location().toString());
        nbt.putString("region", this.region == null ? "" : this.region.location().toString());
        nbt.putString("pokedex", this.pokedex == null ? "" : this.pokedex.location().toString());
    }

    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.filter = PokedexFilter.values()[nbt.getByte("filter")];
        this.caught = nbt.getBoolean("caught");
        String typeString = nbt.getString("pokeType");
        this.type = typeString.isEmpty() ? Type.MYSTERY : ResourceKey.create((ResourceKey)PixelmonRegistry.TYPE_REGISTRY, (ResourceLocation)ResourceLocation.parse((String)typeString));
        String regionString = nbt.getString("region");
        this.region = regionString.isEmpty() ? null : ResourceKey.create((ResourceKey)Region.REGISTRY, (ResourceLocation)ResourceLocation.parse((String)regionString));
        String pokedexString = nbt.getString("pokedex");
        this.pokedex = pokedexString.isEmpty() ? Pokedex.NATIONAL_DEX : ResourceKey.create((ResourceKey)Pokedex.REGISTRY, (ResourceLocation)ResourceLocation.parse((String)pokedexString));
        this.calculateAmount();
    }

    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeByte(this.filter.ordinal());
        buffer.writeBoolean(this.caught);
        buffer.writeUtf(this.type == null ? "" : this.type.location().toString());
        buffer.writeUtf(this.region == null ? "" : this.region.location().toString());
        buffer.writeUtf(this.pokedex == null ? "" : this.pokedex.location().toString());
    }

    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.filter = PokedexFilter.values()[buffer.readByte()];
        this.caught = buffer.readBoolean();
        String typeString = buffer.readUtf();
        this.type = typeString.isEmpty() ? Type.MYSTERY : ResourceKey.create((ResourceKey)PixelmonRegistry.TYPE_REGISTRY, (ResourceLocation)ResourceLocation.parse((String)typeString));
        String regionString = buffer.readUtf();
        this.region = regionString.isEmpty() ? null : ResourceKey.create((ResourceKey)Region.REGISTRY, (ResourceLocation)ResourceLocation.parse((String)regionString));
        String pokedexString = buffer.readUtf();
        this.pokedex = pokedexString.isEmpty() ? Pokedex.NATIONAL_DEX : ResourceKey.create((ResourceKey)Pokedex.REGISTRY, (ResourceLocation)ResourceLocation.parse((String)pokedexString));
        this.calculateAmount();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        PokedexFilter[] filterTypes = PokedexFilter.values();
        ArrayList types = new ArrayList();
        types.addAll(((Registry)Minecraft.getInstance().level.registryAccess().registry(PixelmonRegistry.TYPE_REGISTRY).get()).registryKeySet());
        types.remove(Type.STELLAR);
        ArrayList<String> regions = new ArrayList<String>();
        regions.add("");
        regions.addAll(((Registry)Minecraft.getInstance().level.registryAccess().registry(Region.REGISTRY).get()).registryKeySet().stream().map(ResourceKey::location).map(ResourceLocation::toString).toList());
        config.addEnum("filter", (Object)this.filter, v -> {
            this.filter = v;
            this.calculateAmount();
        }, NameMap.of((Object)((Object)PokedexFilter.ALL), (Object[])filterTypes).nameKey(v -> "pixeltweaks.pokedex_filter_type." + v.name().toLowerCase()).create(), (Object)PokedexFilter.ALL);
        config.addBool("caught", this.caught, v -> {
            this.caught = v;
        }, true);
        config.addEnum("type", this.type, v -> {
            this.type = v;
            this.calculateAmount();
        }, NameMap.of((Object)Type.MYSTERY, types).name(v -> v == Type.MYSTERY ? Component.translatable((String)"pixeltweaks.pokedex_filter.all") : ((Type)((Registry)Minecraft.getInstance().level.registryAccess().registry(PixelmonRegistry.TYPE_REGISTRY).get()).get(v)).name()).icon(v -> Icon.getIcon((ResourceLocation)((Type)((Registry)Minecraft.getInstance().level.registryAccess().registry(PixelmonRegistry.TYPE_REGISTRY).get()).get(v)).icon().getTexture())).create(), (Object)Type.MYSTERY);
        config.addEnum("region", (Object)(this.region == null ? "" : this.region.location().toString()), v -> {
            this.region = v.equals("") ? null : ResourceKey.create((ResourceKey)Region.REGISTRY, (ResourceLocation)ResourceLocation.parse((String)v));
            this.calculateAmount();
        }, NameMap.of((Object)"", regions).name(v -> v.equals("") ? Component.translatable((String)"pixeltweaks.pokedex_filter.globalregion") : ((Region)((Registry)Minecraft.getInstance().level.registryAccess().registry(Region.REGISTRY).get()).get(ResourceLocation.parse((String)v))).name()).create(), (Object)"");
        config.addEnum("pokedex", this.pokedex, v -> {
            this.pokedex = v;
            this.calculateAmount();
        }, NameMap.of((Object)Pokedex.NATIONAL_DEX, (Object[])((Registry)Minecraft.getInstance().level.registryAccess().registry(Pokedex.REGISTRY).get()).registryKeySet().toArray(new ResourceKey[0])).name(v -> Component.literal((String)v.location().getPath())).create(), (Object)Pokedex.NATIONAL_DEX);
    }

    protected void calculateAmount() {
        this.filteredPokedex = this.getPokedex().pokemon().getPokemon().parallelStream().filter(pokemon -> {
            if (this.type != null && this.type != Type.MYSTERY && !pokemon.getForm().hasType(new ResourceKey[]{this.type})) {
                return false;
            }
            boolean found = false;
            for (Region r : this.getRegions()) {
                if (!r.pokemon().contains(pokemon.getDex())) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            if (this.filter == PokedexFilter.STARTERS) {
                for (Region r : this.getRegions()) {
                    for (PokemonBase starter : r.starters()) {
                        if (!starter.getSpecies().equals((Object)pokemon.getSpecies())) continue;
                        return true;
                    }
                }
            } else if (this.filter == PokedexFilter.LEGEND) {
                if (pokemon.getForm().getTags().isLegendary(true)) {
                    return true;
                }
            } else if (this.filter == PokedexFilter.MYTHICAL) {
                if (pokemon.getForm().getTags().isMythical()) {
                    return true;
                }
            } else if (this.filter == PokedexFilter.LEGEND_AND_MYTHICAL) {
                if (pokemon.getForm().getTags().isLegendary(false)) {
                    return true;
                }
            } else if (this.filter == PokedexFilter.ULTRA_BEAST) {
                if (pokemon.getForm().getTags().isUltraBeast()) {
                    return true;
                }
            } else if (this.filter == PokedexFilter.PARADOX) {
                if (PARADOX.contains(pokemon.getSpecies().getDex())) {
                    return true;
                }
            } else {
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
        this.maxPokedexSize = this.filteredPokedex.size();
    }

    public void updatePokedex(TeamData teamData, ServerPlayer player) {
        if (teamData.isCompleted((QuestObject)this) || !teamData.getFile().isServerSide()) {
            return;
        }
        try {
            PokeDexStorageProxy.getStorage((ServerPlayer)player).thenAccept(pokedexStorage -> {
                if (pokedexStorage == null) {
                    return;
                }
                long progress = this.filteredPokedex.parallelStream().filter(poke -> {
                    if (this.caught) {
                        return pokedexStorage.getStatus(poke) == PokedexRegistrationStatus.CAUGHT;
                    }
                    return pokedexStorage.getStatus(poke) == PokedexRegistrationStatus.SEEN || pokedexStorage.getStatus(poke) == PokedexRegistrationStatus.CAUGHT;
                }).count();
                progress = Math.min(progress, this.maxPokedexSize);
                teamData.setProgress((Task)this, (long)((int)progress));
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Region[] getRegions() {
        Object registry = Environment.get().getDist().isClient() && Minecraft.getInstance().level != null ? Minecraft.getInstance().level.registryAccess() : ServerLifecycleHooks.getCurrentServer().registryAccess();
        if (this.region == null) {
            return (Region[])((Registry)registry.registry(Region.REGISTRY).get()).registryKeySet().stream().map(arg_0 -> ((Registry)((Registry)registry.registry(Region.REGISTRY).get())).get(arg_0)).toArray(Region[]::new);
        }
        return new Region[]{(Region)((Registry)registry.registry(Region.REGISTRY).get()).get(this.region)};
    }

    private Pokedex getPokedex() {
        Object registry = Environment.get().getDist().isClient() && Minecraft.getInstance().level != null ? Minecraft.getInstance().level.registryAccess() : ServerLifecycleHooks.getCurrentServer().registryAccess();
        return (Pokedex)((Registry)registry.registry(Pokedex.REGISTRY).get()).get(this.pokedex);
    }

    public static enum PokedexFilter {
        ALL,
        STARTERS,
        LEGEND,
        MYTHICAL,
        LEGEND_AND_MYTHICAL,
        ULTRA_BEAST,
        PARADOX;

    }
}

