/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.integration.jei;

import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.recipe.InfuserRecipe;
import com.pixelmonmod.pixelmon.client.gui.machines.infuser.InfuserContainer;
import com.pixelmonmod.pixelmon.client.gui.machines.infuser.InfuserScreen;
import com.pixelmonmod.pixelmon.entities.npcs.registry.DropItemRegistry;
import com.pixelmonmod.pixelmon.init.registry.ContainerRegistration;
import com.pixelmonmod.pixelmon.init.registry.ItemRegistration;
import com.pixelmonmod.pixelmon.init.registry.PixelmonDataComponents;
import com.pixelmonmod.pixelmon.init.registry.RecipeRegistration;
import com.strangeone101.pixeltweaks.PixelTweaks;
import com.strangeone101.pixeltweaks.integration.jei.PokeLootPool;
import com.strangeone101.pixeltweaks.integration.jei.PokemonIngredient;
import com.strangeone101.pixeltweaks.integration.jei.PokemonIngredientHelper;
import com.strangeone101.pixeltweaks.integration.jei.PokemonIngredientRenderer;
import com.strangeone101.pixeltweaks.integration.jei.category.DropsRecipeCategory;
import com.strangeone101.pixeltweaks.integration.jei.category.InfuserRecipeCategory;
import com.strangeone101.pixeltweaks.integration.jei.category.PokeLootRecipeCategory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class JEIIntegration
implements IModPlugin,
ISubtypeInterpreter<ItemStack> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"pixeltweaks", (String)"jei");
    public static final IIngredientType<Stats> POKEMON = () -> Stats.class;
    public static final IIngredientType<PokemonIngredient> WRAPPED_POKEMON = () -> PokemonIngredient.class;

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ItemRegistration.POKE_BALL.get(), (ISubtypeInterpreter)this);
        registration.registerSubtypeInterpreter((Item)ItemRegistration.POKE_BALL_LID.get(), (ISubtypeInterpreter)this);
        registration.registerSubtypeInterpreter((Item)ItemRegistration.TM_GEN1.get(), (ISubtypeInterpreter)this);
        registration.registerSubtypeInterpreter((Item)ItemRegistration.TM_GEN2.get(), (ISubtypeInterpreter)this);
        registration.registerSubtypeInterpreter((Item)ItemRegistration.TM_GEN3.get(), (ISubtypeInterpreter)this);
        registration.registerSubtypeInterpreter((Item)ItemRegistration.TM_GEN4.get(), (ISubtypeInterpreter)this);
        registration.registerSubtypeInterpreter((Item)ItemRegistration.TM_GEN5.get(), (ISubtypeInterpreter)this);
        registration.registerSubtypeInterpreter((Item)ItemRegistration.TM_GEN6.get(), (ISubtypeInterpreter)this);
        registration.registerSubtypeInterpreter((Item)ItemRegistration.TM_GEN7.get(), (ISubtypeInterpreter)this);
        registration.registerSubtypeInterpreter((Item)ItemRegistration.TM_GEN8.get(), (ISubtypeInterpreter)this);
        registration.registerSubtypeInterpreter((Item)ItemRegistration.TM_GEN9.get(), (ISubtypeInterpreter)this);
        registration.registerSubtypeInterpreter((Item)ItemRegistration.TR_GEN8.get(), (ISubtypeInterpreter)this);
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register(WRAPPED_POKEMON, new HashSet(), (IIngredientHelper)new PokemonIngredientHelper(), (IIngredientRenderer)new PokemonIngredientRenderer(), PokemonIngredient.CODEC);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new DropsRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new PokeLootRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new InfuserRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList drops = new ArrayList();
        for (Species species : DropItemRegistry.pokemonDrops.keySet()) {
            drops.addAll((Collection)DropItemRegistry.pokemonDrops.get(species));
        }
        registration.addRecipes(DropsRecipeCategory.TYPE, drops);
        Supplier type = RecipeRegistration.INFUSER_RECIPE_TYPE;
        if (Minecraft.getInstance().level == null) {
            PixelTweaks.LOGGER.warn("World is null! JEI recipes will not be registered!");
            return;
        }
        List infuserRecipes = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)type.get()).stream().map(rh -> (InfuserRecipe)rh.value()).collect(Collectors.toList());
        registration.addRecipes(InfuserRecipeCategory.TYPE, infuserRecipes);
        PixelTweaks.LOGGER.info("Registered " + infuserRecipes.size() + " infuser recipes to JEI!");
        PokeLootPool tier1 = new PokeLootPool(1, DropItemRegistry.tier1);
        PokeLootPool tier2 = new PokeLootPool(2, DropItemRegistry.tier2);
        PokeLootPool tier3 = new PokeLootPool(3, DropItemRegistry.tier3);
        PokeLootPool tier4 = new PokeLootPool(4, DropItemRegistry.ultraSpace);
        registration.addRecipes(PokeLootRecipeCategory.TYPE, List.of(tier1, tier2, tier3, tier4));
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(InfuserScreen.class, 108, 32, 16, 16, new RecipeType[]{InfuserRecipeCategory.TYPE});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(InfuserContainer.class, (MenuType)ContainerRegistration.INFUSER.get(), InfuserRecipeCategory.TYPE, 1, 2, 9, 36);
    }

    public ResourceLocation getPluginUid() {
        return UID;
    }

    @Nullable
    public Object getSubtypeData(ItemStack ingredient, UidContext context) {
        if (ingredient.get(PixelmonDataComponents.POKE_BALL) != null) {
            return ((RegistryValue)ingredient.get(PixelmonDataComponents.POKE_BALL)).getValue().orElse((PokeBall)PokeBallRegistry.POKE_BALL.getValueUnsafe());
        }
        if (ingredient.get(DataComponents.CUSTOM_DATA) != null && ((CustomData)ingredient.get(DataComponents.CUSTOM_DATA)).contains("tm")) {
            return ((CustomData)ingredient.get(DataComponents.CUSTOM_DATA)).getUnsafe().getShort("tm");
        }
        return null;
    }

    public String getLegacyStringSubtypeInfo(ItemStack ingredient, UidContext context) {
        if (ingredient.get(PixelmonDataComponents.POKE_BALL) != null) {
            return ((RegistryValue)ingredient.get(PixelmonDataComponents.POKE_BALL)).getValue().orElse((PokeBall)PokeBallRegistry.POKE_BALL.getValueUnsafe()).getName();
        }
        if (ingredient.get(DataComponents.CUSTOM_DATA) != null && ((CustomData)ingredient.get(DataComponents.CUSTOM_DATA)).contains("tm")) {
            return String.valueOf(((CustomData)ingredient.get(DataComponents.CUSTOM_DATA)).getUnsafe().getShort("tm"));
        }
        return "";
    }
}

