/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.integration.jei;

import com.mojang.serialization.Codec;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.pokemon.requirement.impl.GenderRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.PaletteRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import java.util.Objects;
import java.util.Optional;

public class PokemonIngredient {
    private Stats stats;
    private Optional<Gender> gender = Optional.empty();
    private Optional<PaletteProperties> palette = Optional.empty();
    private transient PokemonSpecification specification;
    protected Pokemon buildPokemon;
    public static Codec<PokemonIngredient> CODEC = Codec.STRING.xmap(str -> {
        PokemonSpecification spec = (PokemonSpecification)PokemonSpecificationProxy.create((String[])new String[]{str}).get();
        return new PokemonIngredient(spec);
    }, ingredient -> ingredient.specification.toString());

    public PokemonIngredient(PokemonSpecification specification) {
        this.buildPokemon = specification.create();
        this.specification = specification;
        this.stats = this.buildPokemon.getForm();
        if (specification.getValue(GenderRequirement.class).isPresent()) {
            this.gender = Optional.of(this.buildPokemon.getGender());
        }
        if (specification.getValue(PaletteRequirement.class).isPresent()) {
            this.palette = Optional.of(this.buildPokemon.getPalette());
        }
    }

    public Optional<Gender> getGender() {
        return this.gender;
    }

    public Optional<PaletteProperties> getPalette() {
        return this.palette;
    }

    public Stats getForm() {
        return this.stats;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PokemonIngredient that = (PokemonIngredient)o;
        return this.stats.getParentSpecies().equals((Object)that.stats.getParentSpecies()) && this.stats.getName().equalsIgnoreCase(that.stats.getName()) && Objects.equals(this.gender, that.gender) && Objects.equals(this.palette, that.palette);
    }

    public int hashCode() {
        return Objects.hash(this.stats, this.gender, this.palette);
    }
}

