/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.integration.jei;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.SpriteItemHelper;
import com.strangeone101.pixeltweaks.integration.jei.PokemonIngredient;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class PokemonIngredientRenderer
implements IIngredientRenderer<PokemonIngredient> {
    private float scale;

    public PokemonIngredientRenderer(float scale) {
        this.scale = scale;
    }

    public PokemonIngredientRenderer() {
        this(1.0f);
    }

    public int getWidth() {
        return (int)(16.0f * this.scale);
    }

    public int getHeight() {
        return (int)(16.0f * this.scale);
    }

    public void render(GuiGraphics matrixStack, @Nullable PokemonIngredient ingredient) {
        if (ingredient == null) {
            return;
        }
        Pokemon pokemon = ingredient.buildPokemon;
        PokemonIngredientRenderer.renderItem(matrixStack, SpriteItemHelper.getPhoto((Pokemon)pokemon), 0, 0, this.scale);
    }

    public List<Component> getTooltip(PokemonIngredient ingredient, TooltipFlag tooltipFlag) {
        return List.of();
    }

    public void getTooltip(ITooltipBuilder tooltip, PokemonIngredient ingredient, TooltipFlag tooltipFlag) {
        ArrayList<MutableComponent> allTooltips = new ArrayList<MutableComponent>();
        Object species = ingredient.getForm().getParentSpecies().getTranslatedName().getString();
        String form = ingredient.getForm().getLocalizedName();
        String rawForm = ingredient.getForm().getName();
        if (!(form == null || form.isEmpty() || rawForm.equals("") || rawForm.equals("Default"))) {
            species = form + " " + (String)species;
        }
        allTooltips.add(Component.literal((String)species));
        if (ingredient.getPalette().isPresent()) {
            allTooltips.add(Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + ingredient.getPalette().get().getLocalizedName())));
        }
        if (ingredient.getGender().isPresent()) {
            allTooltips.add(Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + ingredient.getGender().get().getLocalizedName())));
        }
        tooltip.addAll(allTooltips);
    }

    public static void renderItem(GuiGraphics matrixStack, ItemStack stack, int x, int y, float scale) {
        boolean flag;
        matrixStack.pose().pushPose();
        BakedModel bakedmodel = Minecraft.getInstance().getItemRenderer().getItemModelShaper().getItemModel(stack);
        bakedmodel = bakedmodel.getOverrides().resolve(bakedmodel, stack, null, null, 0);
        float half = 8.0f * scale;
        float full = 16.0f * scale;
        matrixStack.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.pose().translate((float)x, (float)y, 100.0f);
        matrixStack.pose().translate(half, half, 0.0f);
        matrixStack.pose().scale(1.0f, -1.0f, 1.0f);
        matrixStack.pose().scale(full, full, full);
        boolean bl = flag = !bakedmodel.usesBlockLight();
        if (flag) {
            Lighting.setupForFlatItems();
        }
        Minecraft.getInstance().getItemRenderer().render(stack, ItemDisplayContext.GUI, false, matrixStack.pose(), (MultiBufferSource)matrixStack.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, bakedmodel);
        matrixStack.flush();
        RenderSystem.disableDepthTest();
        if (flag) {
            Lighting.setupFor3DItems();
        }
        matrixStack.pose().popPose();
    }
}

