/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.integration.jei.category;

import com.pixelmonmod.pixelmon.api.pokemon.drops.ItemWithChance;
import com.pixelmonmod.pixelmon.api.pokemon.drops.PokemonDropInformation;
import com.pixelmonmod.pixelmon.init.registry.ItemRegistration;
import com.strangeone101.pixeltweaks.integration.jei.JEIIntegration;
import com.strangeone101.pixeltweaks.integration.jei.PokemonIngredient;
import com.strangeone101.pixeltweaks.integration.jei.PokemonIngredientRenderer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class DropsRecipeCategory
implements IRecipeCategory<PokemonDropInformation> {
    public static final RecipeType<PokemonDropInformation> TYPE = RecipeType.create((String)"pixeltweaks", (String)"drops", PokemonDropInformation.class);
    private static final PokemonIngredientRenderer renderer = new PokemonIngredientRenderer(3.0f);
    private IDrawable bg;
    private final IDrawable icon;
    private final IDrawableStatic slotDrawable;

    public DropsRecipeCategory(IGuiHelper gui) {
        ItemStack itemStack = new ItemStack((Holder)ItemRegistration.QUICK_CLAW);
        this.icon = gui.createDrawableItemStack(itemStack);
        this.slotDrawable = gui.getSlotDrawable();
        this.bg = gui.drawableBuilder(ResourceLocation.fromNamespaceAndPath((String)"pixeltweaks", (String)"textures/jei/drops_bg2.png"), 0, 0, 112, 100).setTextureSize(112, 100).build();
    }

    public RecipeType<PokemonDropInformation> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"jei.pixeltweaks.drops.title");
    }

    public IDrawable getBackground() {
        return this.bg;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PokemonDropInformation recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addInputSlot(6, 6).setCustomRenderer(JEIIntegration.WRAPPED_POKEMON, (IIngredientRenderer)renderer).setPosition(6, 6, 48, 48, HorizontalAlignment.CENTER, VerticalAlignment.CENTER)).addIngredient(JEIIntegration.WRAPPED_POKEMON, (Object)new PokemonIngredient(recipe.getPokemonSpec()));
        for (int i = 0; i < recipe.getDrops().size(); ++i) {
            ((IRecipeSlotBuilder)builder.addOutputSlot(8 + 26 * i, 65).setPosition(8 + 26 * i, 65)).addItemStack(((ItemWithChance)recipe.getDrops().get(i)).getItemStack());
        }
    }

    public void draw(PokemonDropInformation recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        for (int i = 0; i < recipe.getDrops().size(); ++i) {
            ItemWithChance drop = (ItemWithChance)recipe.getDrops().get(i);
            double chance = drop.getChance() * 100.0;
            String chanceString = String.format("%.0f", chance) + "%";
            int w = Minecraft.getInstance().font.width(chanceString);
            guiGraphics.drawString(Minecraft.getInstance().font, chanceString, (float)(8 + 26 * i + 10) - (float)w / 2.0f, 90.0f, 0xFFFFFF, true);
        }
    }
}

