/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.integration.jei.category;

import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.init.registry.ItemRegistration;
import com.pixelmonmod.pixelmon.init.registry.PixelmonDataComponents;
import com.strangeone101.pixeltweaks.integration.jei.PokeLootPool;
import java.util.ArrayList;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IScrollGridWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PokeLootRecipeCategory
implements IRecipeCategory<PokeLootPool> {
    public static final RecipeType<PokeLootPool> TYPE = RecipeType.create((String)"pixeltweaks", (String)"pokeloot", PokeLootPool.class);
    private IDrawable bg;
    private final IDrawable icon;
    private final IDrawable[] pokeballs;

    public PokeLootRecipeCategory(IGuiHelper gui) {
        ItemStack itemStack = new ItemStack((Holder)ItemRegistration.POKE_BALL);
        itemStack.set(PixelmonDataComponents.POKE_BALL, (Object)PokeBallRegistry.BEAST_BALL);
        this.bg = gui.createBlankDrawable(155, 106);
        this.pokeballs = new IDrawable[4];
        this.pokeballs[0] = gui.drawableBuilder(ResourceLocation.fromNamespaceAndPath((String)"pixelmon", (String)"textures/item/pokeballs/poke_ball.png"), 0, 0, 16, 16).setTextureSize(16, 16).build();
        this.pokeballs[1] = gui.drawableBuilder(ResourceLocation.fromNamespaceAndPath((String)"pixelmon", (String)"textures/item/pokeballs/ultra_ball.png"), 0, 0, 16, 16).setTextureSize(16, 16).build();
        this.pokeballs[2] = gui.drawableBuilder(ResourceLocation.fromNamespaceAndPath((String)"pixelmon", (String)"textures/item/pokeballs/master_ball.png"), 0, 0, 16, 16).setTextureSize(16, 16).build();
        this.pokeballs[3] = gui.drawableBuilder(ResourceLocation.fromNamespaceAndPath((String)"pixelmon", (String)"textures/item/pokeballs/beast_ball.png"), 0, 0, 16, 16).setTextureSize(16, 16).build();
        this.icon = this.pokeballs[3];
    }

    public RecipeType<PokeLootPool> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"jei.pixeltweaks.pokeloot.title");
    }

    public IDrawable getBackground() {
        return this.bg;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PokeLootPool recipe, IFocusGroup focuses) {
        Stream<ItemStack> stream = focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK, RecipeIngredientRole.OUTPUT).map(ifocus -> (ItemStack)ifocus.getTypedValue().getIngredient());
        ArrayList<ItemStack> allItems = new ArrayList<ItemStack>(recipe.getItems());
        stream = stream.filter(itemStack -> !allItems.remove(itemStack));
        int offset = 0;
        int columns = 7;
        for (ItemStack stack : (ItemStack[])stream.toArray(ItemStack[]::new)) {
            int x = offset % 7 * 18;
            int y = offset / 7 * 18 + 18;
            builder.createFocusLink(new IIngredientAcceptor[]{((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT).setPosition(x + 1, y + 1)).addItemStack(stack)});
            ++offset;
        }
        for (int i = offset; i < allItems.size(); ++i) {
            int x = i % 7 * 18;
            int y = i / 7 * 18 + 18;
            builder.addSlot(RecipeIngredientRole.OUTPUT).addItemStack((ItemStack)allItems.get(i - offset));
        }
    }

    public void draw(PokeLootPool recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        MutableComponent title = Component.translatable((String)("jei.pixeltweaks.pokeloot.subtitle." + recipe.getTier()));
        int w = Minecraft.getInstance().font.width((FormattedText)title);
        int x = this.bg.getWidth() / 2 - w / 2 + 6;
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)title, x, 4, 0xFFFFFF, true);
        this.pokeballs[recipe.getTier() - 1].draw(guiGraphics, x - 20, 0);
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, PokeLootPool recipe, IFocusGroup focuses) {
        IScrollGridWidget widget = builder.addScrollGridWidget(builder.getRecipeSlots().getSlots(RecipeIngredientRole.OUTPUT), 7, 4);
        widget.setPosition(16, 24, this.getWidth() - 32, this.getHeight() - 32, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM);
    }
}

