/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.mixin.client;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.client.music.BattleMusic;
import com.pixelmonmod.pixelmon.client.music.PixelmonMusic;
import com.pixelmonmod.pixelmon.client.music.VoidMusicTicker;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import com.pixelmonmod.pixelmon.sounds.BattleMusicType;
import com.strangeone101.pixeltweaks.PixelTweaks;
import com.strangeone101.pixeltweaks.music.ChainedMusic;
import com.strangeone101.pixeltweaks.music.MusicEvent;
import com.strangeone101.pixeltweaks.music.SoundManager;
import com.strangeone101.pixeltweaks.pixelevents.EventRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BattleMusic.class})
public abstract class BattleMusicMixin {
    @Shadow(remap=false)
    private static SoundInstance song;

    @Overwrite(remap=false)
    public static void startBattleMusic(BattleMusicType type, int index, long playtime, boolean repeat) {
        PixelTweaks.LOGGER.debug("Starting battle music for " + type.name() + " at index " + index + " with playtime " + playtime + " and repeat " + repeat);
        if (playtime == -1L) {
            BattleMusicMixin.endBattleMusic();
            return;
        }
        ArrayList<PixelmonEntity> opponentEntities = new ArrayList<PixelmonEntity>(1);
        if (!Minecraft.getInstance().isLocalServer()) {
            PixelTweaks.LOGGER.debug("Multi player battle music");
            ArrayList<PixelmonClientData> opponents = new ArrayList<PixelmonClientData>(Arrays.asList(ClientProxy.battleManager.displayedEnemyPokemon));
            for (Entity entity : Minecraft.getInstance().level.entitiesForRendering()) {
                if (!(entity instanceof PixelmonEntity)) continue;
                PixelmonEntity pokemon = (PixelmonEntity)entity;
                Iterator it = opponents.iterator();
                while (it.hasNext()) {
                    PixelmonClientData data = (PixelmonClientData)it.next();
                    if (!data.pokemonUUID.equals(pokemon.getUUID())) continue;
                    opponentEntities.add(pokemon);
                    it.remove();
                    break;
                }
                if (!opponents.isEmpty()) continue;
                break;
            }
        } else {
            PixelTweaks.LOGGER.debug("Single player battle music");
            BattleController controller = BattleRegistry.getBattle((Entity)Minecraft.getInstance().player);
            if (controller == null) {
                PixelTweaks.LOGGER.error("Battle controller is null! Can not load battle music for events!");
            } else {
                PixelTweaks.LOGGER.debug("Controller is " + String.valueOf(controller));
                PlayerParticipant player = controller.getPlayer(Minecraft.getInstance().player.getDisplayName().getString());
                controller.getOpponentPokemon((BattleParticipant)player).stream().map(Pokemon::getEntity).forEach(opponentEntities::add);
            }
        }
        if (!opponentEntities.isEmpty()) {
            Collection<MusicEvent.Battle> events = EventRegistry.getEvents(MusicEvent.Battle.class);
            PixelTweaks.LOGGER.debug("Size is " + events.size());
            Optional<MusicEvent.Battle> optional = events.stream().filter(event -> event.conditions.stream().allMatch(condition -> {
                for (PixelmonEntity opponent : opponentEntities) {
                    if (condition.conditionMet(opponent)) {
                        PixelTweaks.LOGGER.debug("Condition " + condition.toString() + " met!");
                        return true;
                    }
                    PixelTweaks.LOGGER.debug("Condition " + condition.toString() + " failed!");
                }
                return false;
            })).findFirst();
            if (optional.isPresent() && !BattleMusicMixin.isPlaying()) {
                MusicEvent.Battle event2 = optional.get();
                PixelTweaks.LOGGER.debug("Playing sound event " + event2.getFile());
                BattleMusicMixin.pixelTweaks$pause();
                SoundManager.playEvent(event2);
                return;
            }
        }
        Minecraft mc = Minecraft.getInstance();
        BattleMusicMixin.pixelTweaks$pause();
        if (BattleMusicMixin.isPlaying()) {
            mc.getSoundManager().stop(song);
            song = null;
        }
        SoundEvent soundEvent = (SoundEvent)((DeferredHolder)SoundRegistration.BATTLE_MUSIC.get(type)).get();
        BattleMusic.FixedTrackSound record = new BattleMusic.FixedTrackSound(soundEvent, SoundSource.MUSIC, PixelmonConfigProxy.getBattle().getBattleMusicVolume(), 1.0f, RandomSource.create(), new BlockPos(0, 0, 0), index);
        song = record;
        PixelmonMusic.fadeSoundToStart((SoundInstance)record, (long)2000L);
    }

    @Overwrite(remap=false)
    public static void endBattleMusic() {
        Minecraft mc = Minecraft.getInstance();
        if (BattleMusicMixin.isPlaying()) {
            if (BattleMusicMixin.pixelTweaks$isPixelmonSongPlaying()) {
                PixelmonMusic.fadeSoundToStop((SoundInstance)song, (long)2000L, BattleMusicMixin::pixelTweaks$unpause);
            } else {
                CompletableFuture[] futures = new CompletableFuture[SoundManager.BATTLE_MUSIC.size()];
                int num = 0;
                for (ChainedMusic music : SoundManager.BATTLE_MUSIC) {
                    CompletableFuture future = new CompletableFuture();
                    music.finish(() -> {
                        future.complete(null);
                        SoundManager.ALL_MUSIC.remove(music);
                    });
                    futures[num++] = future;
                }
                SoundManager.BATTLE_MUSIC.clear();
                CompletableFuture.allOf(futures).thenAccept(v -> BattleMusicMixin.pixelTweaks$unpause());
            }
        } else if (mc.getMusicManager() instanceof VoidMusicTicker) {
            BattleMusicMixin.pixelTweaks$unpause();
        }
        song = null;
    }

    @Unique
    private static void pixelTweaks$unpause() {
        VoidMusicTicker.restoreMusicTicker();
        SoundManager.resumeAllMusic();
    }

    @Unique
    private static void pixelTweaks$pause() {
        VoidMusicTicker.replaceMusicTicker();
        SoundManager.pauseAllMusic();
    }

    @Overwrite(remap=false)
    public static boolean isPlaying() {
        return SoundManager.BATTLE_MUSIC.size() > 0 && SoundManager.BATTLE_MUSIC.stream().anyMatch(ChainedMusic::isPlaying) || BattleMusicMixin.pixelTweaks$isPixelmonSongPlaying();
    }

    @Unique
    private static boolean pixelTweaks$isPixelmonSongPlaying() {
        return song != null && PixelmonMusic.getSoundHandler().isActive(song);
    }
}

