/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.mixin.client;

import com.pixelmonmod.pixelmon.items.PixelmonItem;
import com.pixelmonmod.pixelmon.items.PokeBallItem;
import com.strangeone101.pixeltweaks.TweaksConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PixelmonItem.class, PokeBallItem.class})
public abstract class PixelmonItemMixin
extends Item {
    @Unique
    private static final int pixelTweaks$LENGTH = 60;

    public PixelmonItemMixin(Item.Properties properties) {
        super(properties);
    }

    @Inject(method={"getTooltipText(Lnet/minecraft/world/item/ItemStack;)Ljava/lang/String;"}, at={@At(value="RETURN")}, remap=false, cancellable=true)
    public void getTooltipText(ItemStack stack, CallbackInfoReturnable<String> cir) {
        String currentText = (String)cir.getReturnValue();
        if ((Integer)TweaksConfig.autoWrapLoreLength.get() > 0) {
            cir.setReturnValue((Object)String.join((CharSequence)"\n", PixelmonItemMixin.pixelTweaks$splitString(currentText, (Integer)TweaksConfig.autoWrapLoreLength.get())));
        }
    }

    @Unique
    private static List<String> pixelTweaks$splitString(String string, int length) {
        Pattern p = Pattern.compile("\\G\\s*(.{1," + length + "})(?=\\s|$)", 32);
        Matcher m = p.matcher(string);
        ArrayList<String> l = new ArrayList<String>();
        char lastColor = '7';
        while (m.find()) {
            String s = m.group(1);
            l.add("\u00a7" + lastColor + s);
            if (!s.contains("\u00a7")) continue;
            lastColor = s.charAt(s.lastIndexOf(167) + 1);
        }
        if (l.isEmpty()) {
            l.add(string);
            return l;
        }
        l.set(0, ((String)l.get(0)).substring(2));
        return l;
    }
}

