/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.mixin.client.network;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.battles.tasks.BattleMessagePacket;
import com.pixelmonmod.pixelmon.battles.tasks.BattleTaskPacket;
import com.pixelmonmod.pixelmon.client.gui.battles.ClientBattleManager;
import com.strangeone101.pixeltweaks.PixelTweaks;
import com.strangeone101.pixeltweaks.client.BattleHelper;
import com.strangeone101.pixeltweaks.music.MusicEvent;
import com.strangeone101.pixeltweaks.music.SoundManager;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BattleMessagePacket.class})
public abstract class BattleMessagePacketMixin
extends BattleTaskPacket {
    @Unique
    private static Predicate<TranslatableContents> pixelTweaks$future = null;
    @Unique
    private static TranslatableContents pixelTweaks$last = null;
    @Shadow(remap=false)
    private Component component;

    @Inject(method={"process"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void onProcess(ClientBattleManager bm, CallbackInfoReturnable<Boolean> cir) {
        String nickname;
        TranslatableContents tcomponent;
        block169: {
            block168: {
                ComponentContents componentContents = this.component.getContents();
                if (!(componentContents instanceof TranslatableContents)) break block168;
                tcomponent = (TranslatableContents)componentContents;
                if (!MusicEvent.BattleAction.REGISTRY.isEmpty()) break block169;
            }
            return;
        }
        if (pixelTweaks$future != null && pixelTweaks$future.test(tcomponent)) {
            pixelTweaks$future = null;
            return;
        }
        MusicEvent.BattleAction.Action action = null;
        MusicEvent.BattleAction.Action subAction = null;
        switch (tcomponent.getKey()) {
            case "pixelmon.effect.accuracyincreased": 
            case "pixelmon.effect.attackincreased": 
            case "pixelmon.effect.defenseincreased": 
            case "pixelmon.effect.spatkincreased": 
            case "pixelmon.effect.spdefincreased": 
            case "pixelmon.effect.speedincreased": 
            case "pixelmon.effect.evasionincreased": {
                action = MusicEvent.BattleAction.Action.STATS_UP;
                break;
            }
            case "pixelmon.effect.accuracyincreased2": 
            case "pixelmon.effect.attackincreased2": 
            case "pixelmon.effect.defenseincreased2": 
            case "pixelmon.effect.spatkincreased2": 
            case "pixelmon.effect.spdefincreased2": 
            case "pixelmon.effect.speedincreased2": 
            case "pixelmon.effect.evasionincreased2": 
            case "pixelmon.effect.accuracyincreased3": 
            case "pixelmon.effect.attackincreased3": 
            case "pixelmon.effect.defenseincreased3": 
            case "pixelmon.effect.spatkincreased3": 
            case "pixelmon.effect.spdefincreased3": 
            case "pixelmon.effect.speedincreased3": 
            case "pixelmon.effect.evasionincreased3": {
                action = MusicEvent.BattleAction.Action.STATS_UP_HARSH;
                subAction = MusicEvent.BattleAction.Action.STATS_UP;
                break;
            }
            case "pixelmon.effect.accuracydecreased": 
            case "pixelmon.effect.attackdecreased": 
            case "pixelmon.effect.defensedecreased": 
            case "pixelmon.effect.spatkdecreased": 
            case "pixelmon.effect.spdefdecreased": 
            case "pixelmon.effect.speeddecreased": 
            case "pixelmon.effect.evasiondecreased": {
                action = MusicEvent.BattleAction.Action.STATS_DOWN;
                break;
            }
            case "pixelmon.effect.accuracydecreased2": 
            case "pixelmon.effect.attackdecreased2": 
            case "pixelmon.effect.defensedecreased2": 
            case "pixelmon.effect.spatkdecreased2": 
            case "pixelmon.effect.spdefdecreased2": 
            case "pixelmon.effect.speeddecreased2": 
            case "pixelmon.effect.evasiondecreased2": 
            case "pixelmon.effect.accuracydecreased3": 
            case "pixelmon.effect.attackdecreased3": 
            case "pixelmon.effect.defensedecreased3": 
            case "pixelmon.effect.spatkdecreased3": 
            case "pixelmon.effect.spdefdecreased3": 
            case "pixelmon.effect.speeddecreased3": 
            case "pixelmon.effect.evasiondecreased3": {
                action = MusicEvent.BattleAction.Action.STATS_DOWN_HARSH;
                subAction = MusicEvent.BattleAction.Action.STATS_DOWN;
                break;
            }
            case "pixelmon.effect.burnt": 
            case "pixelmon.status.burnhurt": 
            case "pixelmon.status.burn.added": {
                action = MusicEvent.BattleAction.Action.BURN;
                break;
            }
            case "pixelmon.effect.frozesolid": 
            case "pixelmon.status.frozensolid": {
                action = MusicEvent.BattleAction.Action.FREEZE;
                break;
            }
            case "pixelmon.status.isparalyzed": {
                action = MusicEvent.BattleAction.Action.PARALYZE;
                break;
            }
            case "pixelmon.effect.poisoned": 
            case "pixelmon.effect.badlypoisoned": 
            case "pixelmon.status.hurtbypoison": {
                action = MusicEvent.BattleAction.Action.POISON;
                break;
            }
            case "pixelmon.status.fellasleep": 
            case "pixelmon.status.stillsleeping": 
            case "pixelmon.effect.fallasleep": 
            case "pixelmon.effect.healthsleep": {
                action = MusicEvent.BattleAction.Action.SLEEP;
                break;
            }
            case "pixelmon.status.confused": 
            case "pixelmon.effect.confusion": 
            case "pixelmon.effect.thrash": {
                action = MusicEvent.BattleAction.Action.CONFUSION;
                break;
            }
            case "pixelmon.status.inlove": {
                action = MusicEvent.BattleAction.Action.LOVE;
                break;
            }
            case "pixelmon.status.drowsy": {
                action = MusicEvent.BattleAction.Action.DROWSY;
                break;
            }
            case "pixelmon.effect.critincreased": {
                action = MusicEvent.BattleAction.Action.GETTING_PUMPED;
                break;
            }
            case "pixelmon.effect.wrapped": 
            case "pixelmon.effect.squeezed": {
                action = MusicEvent.BattleAction.Action.WRAP;
                break;
            }
            case "pixelmon.effect.spikes": 
            case "pixelmon.effect.morespikes": 
            case "pixelmon.effect.floatingstones": 
            case "pixelmon.effect.sharpsteel": {
                action = MusicEvent.BattleAction.Action.SPIKES;
                break;
            }
            case "pixelmon.effect.toxicspikes": 
            case "pixelmon.effect.moretoxicspikes": {
                action = MusicEvent.BattleAction.Action.POISON;
                subAction = MusicEvent.BattleAction.Action.SPIKES;
                break;
            }
            case "pixelmon.effect.uplightscreen": {
                action = MusicEvent.BattleAction.Action.LIGHT_SCREEN;
                break;
            }
            case "pixelmon.effect.reflectraised": {
                action = MusicEvent.BattleAction.Action.REFLECT;
                break;
            }
            case "pixelmon.effect.raining": 
            case "pixelmon.abilities.drizzle": {
                action = MusicEvent.BattleAction.Action.WEATHER_RAINY;
                break;
            }
            case "pixelmon.effect.starthail": 
            case "pixelmon.abilities.snowwarning": {
                action = MusicEvent.BattleAction.Action.WEATHER_HAIL;
                break;
            }
            case "pixelmon.status.extremelyheavyrain": {
                action = MusicEvent.BattleAction.Action.WEATHER_VERY_RAINY;
                subAction = MusicEvent.BattleAction.Action.WEATHER_RAINY;
                break;
            }
            case "pixelmon.effect.sandstorm": 
            case "pixelmon.abilities.sandstream": 
            case "pixelmon.abilities.sandspit": {
                action = MusicEvent.BattleAction.Action.WEATHER_SANDSTORM;
                break;
            }
            case "pixelmon.effect.startsnow": {
                action = MusicEvent.BattleAction.Action.WEATHER_SNOW;
                break;
            }
            case "pixelmon.effect.harshsunlight": 
            case "pixelmon.abilities.drought": {
                action = MusicEvent.BattleAction.Action.WEATHER_SUNNY;
                break;
            }
            case "pixelmon.effect.extremelybrightlight": {
                action = MusicEvent.BattleAction.Action.WEATHER_VERY_SUNNY;
                subAction = MusicEvent.BattleAction.Action.WEATHER_SUNNY;
                break;
            }
            case "battlecontroller.fainted": 
            case "battlecontroller.hasfainted": {
                action = MusicEvent.BattleAction.Action.FAINT;
                break;
            }
            case "battlecontroller.outofpokemon": {
                action = MusicEvent.BattleAction.Action.WIPEOUT;
                break;
            }
            case "battlecontroller.sendout": {
                action = MusicEvent.BattleAction.Action.SWITCH;
                break;
            }
            case "battlecontroller.win": {
                action = MusicEvent.BattleAction.Action.WIN;
                pixelTweaks$future = null;
                break;
            }
            case "battlecontroller.flinched": {
                action = MusicEvent.BattleAction.Action.FLINCH;
                break;
            }
            case "battlecontroller.escaped": {
                action = MusicEvent.BattleAction.Action.RUN;
                pixelTweaks$future = null;
                break;
            }
            case "pixelmon.pokeballs.throw": {
                action = MusicEvent.BattleAction.Action.THROW_POKEBALL;
                break;
            }
            case "pixelmon.pokeballs.brokefree": {
                action = MusicEvent.BattleAction.Action.CATCH_FAIL;
                break;
            }
            case "pixelmon.pokeballs.capture": {
                action = MusicEvent.BattleAction.Action.CATCH;
                break;
            }
            case "pixelmon.effect.revived": {
                action = MusicEvent.BattleAction.Action.REVIVE;
                subAction = MusicEvent.BattleAction.Action.POTION;
                break;
            }
            case "pixelmon.effect.restorehealth": {
                action = MusicEvent.BattleAction.Action.POTION;
                break;
            }
            case "pixelmon.helditems.consumerestorehp": 
            case "pixelmon.helditems.consumeleppa": 
            case "pixelmon.helditems.pinchberry": 
            case "pixelmon.helditems.custapberry": 
            case "pixelmon.helditems.pumkinberry": {
                action = MusicEvent.BattleAction.Action.BERRY_EAT;
                break;
            }
            case "pixelmon.battletext.megareact": 
            case "pixelmon.battletext.ashgreninja.react": 
            case "pixelmon.battletext.rayquazamegareact": {
                action = MusicEvent.BattleAction.Action.MEGA_EVOLVE;
                break;
            }
            case "pixelmon.battletext.dynamax": {
                action = MusicEvent.BattleAction.Action.DYNAMAX;
                break;
            }
            case "pixelmon.battletext.dynamaxlost": {
                action = MusicEvent.BattleAction.Action.DYNAMAX_LOST;
                break;
            }
            case "battlecontroller.initbattle.you": 
            case "battlecontroller.initbattle.toyou": {
                action = MusicEvent.BattleAction.Action.START;
                pixelTweaks$future = null;
                break;
            }
            case "battlecontroller.forfeit": 
            case "battlecontroller.forfeitself": 
            case "battlecontroller.draw": {
                pixelTweaks$future = null;
                break;
            }
            case "pixelmon.battletext.used": {
                String move;
                MutableComponent tcomponent2;
                Object object = tcomponent.getArgs()[1];
                if (object instanceof MutableComponent && (object = (tcomponent2 = (MutableComponent)object).getContents()) instanceof TranslatableContents) {
                    TranslatableContents tcomponent3 = (TranslatableContents)object;
                    move = tcomponent3.getKey().split("\\.", 2)[1].replace('_', ' ');
                } else {
                    move = tcomponent.getArgs()[1].toString();
                }
                Optional attack = AttackRegistry.getAttackBase((String)move);
                attack.ifPresent(attackBase -> {
                    boolean statusMove = attackBase.getAttackCategory() == AttackCategory.STATUS;
                    PixelTweaks.LOGGER.debug("Move " + move + " is a " + String.valueOf(attackBase.getAttackCategory()) + " move");
                    pixelTweaks$future = component -> {
                        String key = component.getKey();
                        String lastPokemon = pixelTweaks$last != null ? pixelTweaks$last.getArgs()[0].toString() : null;
                        switch (key) {
                            case "pixelmon.battletext.missedattack": {
                                SoundManager.playBattleAction(BattleHelper.getFromNickname(lastPokemon), MusicEvent.BattleAction.Action.HIT_MISS);
                                return true;
                            }
                            case "pixelmon.battletext.butmovefailed": 
                            case "pixelmon.battletext.movefailed": {
                                SoundManager.playBattleAction(BattleHelper.getFromNickname(lastPokemon), MusicEvent.BattleAction.Action.HIT_FAIL);
                                return true;
                            }
                            case "pixelmon.battletext.noeffect": {
                                SoundManager.playBattleAction(BattleHelper.getFromNickname(lastPokemon), MusicEvent.BattleAction.Action.HIT_NO_EFFECT);
                                return true;
                            }
                            case "pixelmon.battletext.criticalhit": 
                            case "pixelmon.battletext.criticalhittarget": {
                                if (!statusMove) {
                                    SoundManager.playBattleAction(BattleHelper.getFromNickname(lastPokemon), MusicEvent.BattleAction.Action.HIT_CRITICAL, MusicEvent.BattleAction.Action.HIT);
                                }
                                return true;
                            }
                            case "pixelmon.battletext.wasnoteffective": 
                            case "pixelmon.battletext.wasnoteffectivetarget": {
                                if (!statusMove) {
                                    SoundManager.playBattleAction(BattleHelper.getFromNickname(lastPokemon), MusicEvent.BattleAction.Action.NOT_VERY_EFFECTIVE_HIT, MusicEvent.BattleAction.Action.HIT);
                                }
                                return true;
                            }
                            case "pixelmon.battletext.supereffective": 
                            case "pixelmon.battletext.supereffectivetarget": {
                                if (!statusMove) {
                                    SoundManager.playBattleAction(BattleHelper.getFromNickname(lastPokemon), MusicEvent.BattleAction.Action.SUPER_EFFECTIVE_HIT, MusicEvent.BattleAction.Action.HIT);
                                }
                                return true;
                            }
                        }
                        if (!statusMove) {
                            SoundManager.playBattleAction(BattleHelper.getFromNickname(lastPokemon), MusicEvent.BattleAction.Action.EFFECTIVE_HIT, MusicEvent.BattleAction.Action.HIT);
                        }
                        return false;
                    };
                });
                if (!attack.isPresent()) {
                    PixelTweaks.LOGGER.warn("Could not find attack " + move);
                }
                pixelTweaks$last = tcomponent;
            }
        }
        String string = nickname = tcomponent.getArgs().length > 0 ? tcomponent.getArgs()[0].toString() : null;
        if (subAction != null) {
            PixelTweaks.LOGGER.debug("Playing action " + String.valueOf((Object)action) + "/" + String.valueOf((Object)subAction) + " for " + nickname);
            SoundManager.playBattleAction(BattleHelper.getFromNickname(nickname), action, subAction);
        } else if (action != null) {
            PixelTweaks.LOGGER.debug("Playing action " + String.valueOf((Object)action) + " for " + nickname);
            SoundManager.playBattleAction(BattleHelper.getFromNickname(nickname), action);
        }
    }
}

