/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.strangeone101.pixeltweaks.particle.FakeParticle;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StarParticle
extends FakeParticle {
    private static final ResourceLocation tex = ResourceLocation.fromNamespaceAndPath((String)"pixeltweaks", (String)"textures/particles/stars_0.png");
    private static final ResourceLocation tex2 = ResourceLocation.fromNamespaceAndPath((String)"pixeltweaks", (String)"textures/particles/stars_1.png");
    public static SpriteSet SPRITES;
    private float angleDirection;
    private int startAge;
    private float prevScale;
    private float prevAlpha;
    private float localScale;
    private float drag = 0.9f;
    private static final float[] sizeScale;
    private static final int[] fadeColors;
    private static final int color = 0xEFEF00;

    public StarParticle(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z, motionX, motionY, motionZ);
        this.xd = motionX + (Math.random() * 2.0 - 1.0) * (double)0.1f;
        this.yd = motionY + (Math.random() * 2.0 - 1.0) * (double)0.1f;
        this.zd = motionZ + (Math.random() * 2.0 - 1.0) * (double)0.1f;
        this.startAge = world.random.nextInt(3);
        this.lifetime = this.startAge + 15;
        this.localScale = 0.5f + world.random.nextFloat() * 1.5f;
        this.oRoll = this.roll = world.random.nextFloat();
        this.rCol = 1.0f - world.random.nextFloat() * 0.015f;
        this.gCol = 1.0f - world.random.nextFloat() * 0.015f;
        this.bCol = 1.0f - world.random.nextFloat() * 0.015f;
        this.gravity = 0.4f;
        this.angleDirection = world.random.nextFloat() > 0.5f ? 1.0f : -1.0f;
        this.quadSize = 0.0f;
        this.setSize(0.0f, 0.0f);
        this.pickSprite(SPRITES);
    }

    public void tick() {
        int realAge = this.age - this.startAge;
        if (realAge < 0) {
            ++this.age;
            return;
        }
        this.standardTick();
        this.oRoll = this.roll;
        this.roll += this.angleDirection * 0.5f;
        this.prevScale = this.quadSize;
        float f = 0.1f * sizeScale[realAge % 15] * this.getViewScale() * this.localScale;
        this.setSize(f, f);
        this.quadSize = f;
        this.prevAlpha = this.alpha;
        this.alpha = realAge >= 10 ? 1.0f - (float)(realAge - 10) / 5.0f : 1.0f;
    }

    private void standardTick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.yd -= 0.04 * (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            this.xd *= (double)this.drag;
            this.yd *= (double)this.drag;
            this.zd *= (double)this.drag;
            if (this.onGround) {
                this.xd *= (double)0.7f;
                this.zd *= (double)0.7f;
            }
        }
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        float f2;
        float f = this.alpha;
        this.alpha = f2 = Mth.lerp((float)partialTicks, (float)this.prevAlpha, (float)this.alpha);
        super.render(buffer, renderInfo, partialTicks);
        this.alpha = f;
    }

    public float getQuadSize(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.prevScale, (float)this.quadSize);
    }

    protected void setSize(float particleWidth, float particleHeight) {
        double xOff = this.bbWidth - particleWidth;
        double yOff = this.bbHeight - particleHeight;
        super.setSize(particleWidth, particleHeight);
        this.move(xOff, yOff, xOff);
    }

    private float getViewScale() {
        return 0.1f + (float)Math.sqrt(Minecraft.getInstance().player.position().distanceToSqr(this.x, this.y, this.z)) / 5.0f;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    protected int getLightColor(float partialTick) {
        return 0xF000F0;
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return ResourceLocation.fromNamespaceAndPath((String)"pixeltweaks", (String)"star");
    }

    static {
        sizeScale = new float[]{0.1f, 0.2f, 0.35f, 0.5f, 0.65f, 0.8f, 0.85f, 1.0f, 1.0f, 1.0f, 1.0f, 0.85f, 0.45f, 0.2f, 0.1f};
        fadeColors = new int[]{54765, 13893864, 15018496, 9823488, 14842880, 5374176};
    }
}

