/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.pixelevents.condition;

import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.strangeone101.pixeltweaks.pixelevents.Condition;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class BiomeCondition
extends Condition<ResourceLocation> {
    public transient Set<ResourceLocation> cachedBiomes;
    public List<String> biomes;
    boolean invert = false;

    @Override
    public boolean conditionMet(ResourceLocation item) {
        if (this.cachedBiomes == null) {
            HashSet cache = new HashSet();
            for (String biome : this.biomes) {
                if (biome.startsWith("#")) continue;
                if (biome.contains(":")) {
                    this.cachedBiomes.add(ResourceLocation.parse((String)biome.toLowerCase()));
                    continue;
                }
                this.cachedBiomes.add(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)biome.toLowerCase()));
            }
        }
        return this.cachedBiomes.contains(item) != this.invert;
    }

    @Override
    public ResourceLocation itemFromPixelmon(PixelmonEntity entity) {
        Biome biome = (Biome)Minecraft.getInstance().level.getBiome(entity.getOnPos()).value();
        return BiomeCondition.getBiome(biome);
    }

    public static ResourceLocation getBiome(Biome biome) {
        if (biome == null) {
            return null;
        }
        ResourceLocation l = ((Registry)Minecraft.getInstance().level.registryAccess().registry(Registries.BIOME).get()).getKey((Object)biome);
        if (l == null) {
            return null;
        }
        return l;
    }

    @Override
    public String toString() {
        return "BiomeCondition{biomes=" + String.valueOf(this.biomes) + ", invert=" + this.invert + "}";
    }
}

