/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.pixelevents.condition;

import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.strangeone101.pixeltweaks.pixelevents.Condition;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.dimension.DimensionType;

public class DimensionCondition
extends Condition<ResourceLocation> {
    public List<ResourceLocation> dimensions;
    boolean invert = false;

    @Override
    public boolean conditionMet(ResourceLocation item) {
        return this.dimensions.contains(item) != this.invert;
    }

    @Override
    public ResourceLocation itemFromPixelmon(PixelmonEntity entity) {
        DimensionType dim = entity.level().dimensionType();
        return DimensionCondition.getDimension(dim);
    }

    public static ResourceLocation getDimension(DimensionType dim) {
        return ((Registry)Minecraft.getInstance().level.registryAccess().registry(Registries.DIMENSION_TYPE).get()).getKey((Object)dim);
    }

    @Override
    public String toString() {
        return "DimensionCondition{dimensions=" + String.valueOf(this.dimensions) + ", invert=" + this.invert + "}";
    }
}

