/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.pixelevents.condition;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.strangeone101.pixeltweaks.pixelevents.Condition;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;

public class PlayerCondition
extends Condition<Player> {
    public UUID uuid;
    public String name;
    public int minPartyLevel = 0;
    public int maxPartyLevel = 100;

    @Override
    public boolean conditionMet(Player player) {
        if (player == null) {
            return false;
        }
        if (this.uuid != null && !player.getUUID().equals(this.uuid)) {
            return false;
        }
        if (this.name != null && !player.getName().getString().equals(this.name)) {
            return false;
        }
        if (Minecraft.getInstance().isLocalServer()) {
            PlayerPartyStorage storage = null;
            try {
                storage = (PlayerPartyStorage)StorageProxy.getParty((UUID)player.getUUID()).get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            int minLevel = 100;
            int maxLevel = 0;
            for (int i = 0; i < 6; ++i) {
                Pokemon pokemon = storage.get(new StoragePosition(-1, i));
                if (pokemon == null) continue;
                minLevel = Math.min(minLevel, pokemon.getPokemonLevel());
                maxLevel = Math.max(maxLevel, pokemon.getPokemonLevel());
            }
            if (minLevel < this.minPartyLevel) {
                return false;
            }
            if (maxLevel > this.maxPartyLevel) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Player itemFromPixelmon(PixelmonEntity entity) {
        if (entity.getOwner() instanceof Player) {
            return (Player)entity.getOwner();
        }
        return null;
    }

    @Override
    public String toString() {
        return "PlayerCondition{uuid=" + String.valueOf(this.uuid) + ", name='" + this.name + "', minPartyLevel=" + this.minPartyLevel + ", maxPartyLevel=" + this.maxPartyLevel + "}";
    }
}

