/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.pixelevents.condition;

import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.strangeone101.pixeltweaks.pixelevents.Condition;
import java.util.function.Predicate;
import net.minecraft.world.level.Level;

public class TimeCondition
extends Condition<Level> {
    public Time time = Time.DAY;
    boolean invert = false;

    @Override
    public boolean conditionMet(Level item) {
        return this.time.checkTime.test(item.getDayTime()) != this.invert;
    }

    @Override
    public Level itemFromPixelmon(PixelmonEntity entity) {
        return entity.level();
    }

    @Override
    public String toString() {
        return "TimeCondition{time=" + this.time.name() + ", invert=" + this.invert + "}";
    }

    public static enum Time {
        DAY(time -> time >= 1000L && time < 13000L),
        NIGHT(time -> time < 1000L || time >= 13000L);

        private final Predicate<Long> checkTime;

        private Time(Predicate<Long> checkTime) {
            this.checkTime = checkTime;
        }
    }
}

