/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.pixellang;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;

public class LangRegistry {
    private static final Map<String, String> DEFAULTS = new HashMap<String, String>();
    private static final Map<String, JsonObject> REGISTRY = new HashMap<String, JsonObject>();
    private static final String DEFAULT_LANG = "en_us";

    public LangRegistry() {
        DEFAULTS.put("en", DEFAULT_LANG);
        NeoForge.EVENT_BUS.addListener(this::registerReload);
    }

    protected static String resolveLocale(String locale) {
        if (REGISTRY.containsKey(locale)) {
            return locale;
        }
        String baseLang = DEFAULTS.get(locale.substring(0, 2));
        if (DEFAULTS.containsKey(baseLang)) {
            return DEFAULTS.get(baseLang);
        }
        return DEFAULT_LANG;
    }

    public static void sendMessage(ServerPlayer player, String langNode, Object ... args) {
        player.sendSystemMessage(LangRegistry.getMessage(player, langNode, args));
    }

    public static Component getMessage(ServerPlayer player, String langNode, Object ... args) {
        String locale = player.getLanguage();
        String resolved = LangRegistry.resolveLocale(locale);
        JsonObject object = REGISTRY.get(resolved);
        if (object == null) {
            return Component.translatable((String)langNode, (Object[])args);
        }
        String message = String.format(object.get(langNode).getAsString(), args);
        if (message == null) {
            return Component.translatable((String)langNode, (Object[])args);
        }
        return Component.literal((String)message);
    }

    protected void registerReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new LangReloader());
    }

    private static class LangReloader
    extends SimpleJsonResourceReloadListener {
        public LangReloader() {
            super(new GsonBuilder().setPrettyPrinting().setLenient().create(), "pixellang");
        }

        protected void apply(Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
            for (ResourceLocation resourceLocation : resourceLocationJsonElementMap.keySet()) {
                String code = resourceLocation.getPath();
                JsonObject object = resourceLocationJsonElementMap.get(resourceLocation).getAsJsonObject();
                if (REGISTRY.containsKey(code)) {
                    JsonObject oldObject = REGISTRY.get(code);
                    for (Map.Entry entry : oldObject.entrySet()) {
                        if (object.has((String)entry.getKey())) continue;
                        object.add((String)entry.getKey(), (JsonElement)entry.getValue());
                    }
                }
                REGISTRY.put(code, object);
            }
        }

        public String getName() {
            return "PixelTweaks Lang Reloader";
        }
    }
}

