/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.struct;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.strangeone101.pixeltweaks.PixelTweaks;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class SpecificTime {
    public int year = -1;
    public int month = -1;
    public int day_of_week = -1;
    public int day = -1;
    public int hour = -1;
    public int minute = -1;

    public Calendar getTime() {
        Calendar calendar = Calendar.getInstance();
        if (this.year != -1) {
            calendar.set(1, this.year);
        }
        if (this.month != -1) {
            calendar.set(2, this.month);
        }
        if (this.day_of_week != -1) {
            calendar.set(7, this.day_of_week);
        }
        if (this.day != -1) {
            calendar.set(5, this.day);
        }
        if (this.hour != -1) {
            calendar.set(11, this.hour);
        }
        if (this.minute != -1) {
            calendar.set(12, this.minute);
        }
        return calendar;
    }

    public boolean validate() {
        try {
            Calendar instance = Calendar.getInstance();
            if (this.year != -1) {
                instance.set(1, this.year);
            }
            if (this.month != -1) {
                instance.set(2, this.month);
            }
            if (this.day_of_week != -1) {
                instance.set(7, this.day_of_week);
            }
            if (this.day != -1) {
                instance.set(5, this.day);
            }
            if (this.hour != -1) {
                instance.set(11, this.hour);
            }
            if (this.minute != -1) {
                instance.set(12, this.minute);
            }
            return true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public static boolean isBetween(SpecificTime start, SpecificTime end) {
        Calendar startCalendar = start.getTime();
        Calendar endCalendar = end.getTime();
        Calendar now = Calendar.getInstance();
        endCalendar.add(13, 1);
        return now.after(startCalendar) && now.before(endCalendar);
    }

    public static class Deserializer
    implements JsonDeserializer<SpecificTime> {
        public SpecificTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Calendar cal;
            Date date;
            SpecificTime time = new SpecificTime();
            if (!json.isJsonObject()) {
                return null;
            }
            if (json.getAsJsonObject().has("year")) {
                time.year = json.getAsJsonObject().get("year").getAsInt();
            }
            if (json.getAsJsonObject().has("month")) {
                JsonElement month = json.getAsJsonObject().get("month");
                if (month.isJsonPrimitive() && month.getAsJsonPrimitive().isNumber()) {
                    time.month = month.getAsInt() - 1;
                } else {
                    date = null;
                    try {
                        date = new SimpleDateFormat("MMM", Locale.ENGLISH).parse(month.getAsString());
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                    cal = Calendar.getInstance();
                    cal.setTime(date);
                    time.month = cal.get(2);
                }
            }
            if (json.getAsJsonObject().has("day")) {
                time.day = json.getAsJsonObject().get("day").getAsInt() - 1;
            }
            if (json.getAsJsonObject().has("day_of_week")) {
                JsonElement day = json.getAsJsonObject().get("day_of_week");
                if (day.isJsonPrimitive() && day.getAsJsonPrimitive().isNumber()) {
                    time.day_of_week = day.getAsInt() - 1;
                } else {
                    date = null;
                    try {
                        date = new SimpleDateFormat("EEE", Locale.ENGLISH).parse(day.getAsString());
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                    cal = Calendar.getInstance();
                    cal.setTime(date);
                    time.day_of_week = cal.get(7);
                }
            }
            if (json.getAsJsonObject().has("hour")) {
                time.hour = json.getAsJsonObject().get("hour").getAsInt();
            }
            if (json.getAsJsonObject().has("minute")) {
                time.minute = json.getAsJsonObject().get("minute").getAsInt();
            }
            if (time.validate()) {
                return time;
            }
            PixelTweaks.LOGGER.error("Invalid time: " + json.toString());
            return time;
        }
    }
}

