/*
 * Decompiled with CFR 0.152.
 */
package com.saltywater.jumpanimation;

import com.saltywater.jumpanimation.JumpAnimationConfig;
import com.saltywater.jumpanimation.networking.JumpAnimationNetworking;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod.EventBusSubscriber(modid="jumpanimation", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class JumpAnimationClient {
    private static final ResourceLocation JUMP_ANIMATION_ID = new ResourceLocation("jumpanimation", "jump");
    private static final ResourceLocation JUMPFLIP_ANIMATION_ID = new ResourceLocation("jumpanimation", "jumpflip");
    private static final ResourceLocation DIVING_ANIMATION_ID = new ResourceLocation("jumpanimation", "diving");
    private static final ResourceLocation CANNONBALL_ANIMATION_ID = new ResourceLocation("jumpanimation", "cannonball");
    private static final ResourceLocation ROLL_ANIMATION_ID = new ResourceLocation("jumpanimation", "roll");
    private static final ResourceLocation SWIMUP_ANIMATION_ID = new ResourceLocation("jumpanimation", "swimup");
    private static final ResourceLocation DIVING_CANNONBALL_ANIMATION_ID = new ResourceLocation("jumpanimation", "divingcannonball");
    private static final ResourceLocation HAYSTACK_LANDING_ANIMATION_ID = new ResourceLocation("jumpanimation", "haysackland");
    private static final ResourceLocation STOPPED_JUMP_ANIMATION_ID = new ResourceLocation("jumpanimation", "stoppedjump");
    private static final ResourceLocation STOPPED_JUMPFLIP_ANIMATION_ID = new ResourceLocation("jumpanimation", "stoppedjumpflip");
    private static final ResourceLocation RUNNING_JUMP_ANIMATION_ID = new ResourceLocation("jumpanimation", "runningjump");
    private static final ResourceLocation RUNNING_JUMPFLIP_ANIMATION_ID = new ResourceLocation("jumpanimation", "runningjumpflip");
    private static final ResourceLocation FALL_ANIMATION_ID = new ResourceLocation("jumpanimation", "fall");
    private static final ResourceLocation HIGHFALL_ANIMATION_ID = new ResourceLocation("jumpanimation", "highfall");
    private static final ResourceLocation FALLING_ANIMATION_ID = new ResourceLocation("jumpanimation", "falling");
    private boolean playJumpNext = true;
    private boolean wasJumping = false;
    private boolean wasOnGround = true;
    private boolean wasClimbing = false;
    private boolean wasInWater = false;
    private boolean isFallingAnimationPlaying = false;
    private boolean isDiving = false;
    private boolean isCannonballing = false;
    private int climbCooldownTicks = 2;
    private float fallDistance = 0.0f;
    private int fallSlowdownTicks = 0;
    private int highFallSlowdownTicks = 0;
    private int haystackSlowdownTicks = 0;

    public static void registerClient() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(JumpAnimationClient::onClientSetup);
        MinecraftForge.EVENT_BUS.register((Object)new JumpAnimationClient());
    }

    private static void onClientSetup(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        LocalPlayer player;
        block33: {
            block32: {
                Player player2 = event.player;
                if (!(player2 instanceof LocalPlayer)) break block32;
                player = (LocalPlayer)player2;
                if (event.phase == TickEvent.Phase.END) break block33;
            }
            return;
        }
        if (!this.isPlayerInSurvival(player)) {
            return;
        }
        JumpAnimationConfig config = JumpAnimationConfig.getConfig();
        boolean isOnGround = player.m_20096_();
        boolean isInWater = player.m_20069_();
        boolean isJumping = !isOnGround && player.m_20184_().f_82480_ > 0.0;
        boolean isFalling = !isOnGround && player.m_20184_().f_82480_ < 0.0;
        boolean isClimbing = player.m_6147_();
        if (isInWater && !this.wasInWater) {
            if (this.isDiving) {
                this.playAnimation(player, SWIMUP_ANIMATION_ID);
            } else if (this.isCannonballing) {
                this.playAnimation(player, DIVING_CANNONBALL_ANIMATION_ID);
            }
            this.isDiving = false;
            this.isCannonballing = false;
            this.fallDistance = 0.0f;
        }
        if (isInWater) {
            this.wasJumping = isJumping;
            this.wasOnGround = isOnGround;
            this.wasInWater = true;
            return;
        }
        if (isClimbing) {
            this.wasClimbing = true;
            this.climbCooldownTicks = 2;
            this.wasJumping = false;
            return;
        }
        if (this.climbCooldownTicks > 0) {
            --this.climbCooldownTicks;
            return;
        }
        if (this.wasClimbing && !isClimbing) {
            this.wasClimbing = false;
        }
        this.applyFallSlowdown(player, config);
        if (isFalling && this.fallDistance >= 6.0f && !this.isFallingAnimationPlaying && !this.isDiving && !this.isCannonballing) {
            this.playAnimation(player, FALLING_ANIMATION_ID);
            this.isFallingAnimationPlaying = true;
        }
        if (isJumping && !this.wasJumping) {
            boolean isRunning = this.isPlayerRunning(player);
            boolean isStopped = this.isPlayerStopped(player);
            if (isStopped) {
                this.playNextStoppedJumpAnimation(player);
            } else {
                this.playNextRunningJumpAnimation(player, isRunning);
            }
        }
        if (!isOnGround && !isInWater) {
            this.fallDistance = Math.max(this.fallDistance, player.f_19789_);
        } else if (!this.wasOnGround) {
            if (!this.isDiving && !this.isCannonballing && this.isOnHaystack(player) && this.fallDistance >= 3.0f) {
                this.playAnimation(player, HAYSTACK_LANDING_ANIMATION_ID);
                this.haystackSlowdownTicks = config.haystackSlowdownDurationTicks;
            } else if (this.isDiving) {
                this.playAnimation(player, ROLL_ANIMATION_ID);
            } else if (this.isCannonballing) {
                if (this.fallDistance >= 6.0f) {
                    this.playFallAnimation(player, HIGHFALL_ANIMATION_ID);
                    this.highFallSlowdownTicks = config.highFallSlowdownDurationTicks;
                } else if (this.fallDistance >= 3.0f) {
                    this.playFallAnimation(player, FALL_ANIMATION_ID);
                    this.fallSlowdownTicks = config.fallSlowdownDurationTicks;
                }
            } else if (this.fallDistance >= 6.0f && !this.isDiving && !this.isCannonballing) {
                this.playFallAnimation(player, HIGHFALL_ANIMATION_ID);
                this.highFallSlowdownTicks = config.highFallSlowdownDurationTicks;
            } else if (this.fallDistance >= 3.0f && !this.isDiving && !this.isCannonballing) {
                this.playFallAnimation(player, FALL_ANIMATION_ID);
                this.fallSlowdownTicks = config.fallSlowdownDurationTicks;
            }
            this.isFallingAnimationPlaying = false;
            this.isDiving = false;
            this.isCannonballing = false;
            this.fallDistance = 0.0f;
        }
        this.wasOnGround = isOnGround;
        this.wasJumping = isJumping;
        this.wasInWater = isInWater;
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (!this.isPlayerInSurvival(player)) {
            return;
        }
        if (this.haystackSlowdownTicks > 0) {
            return;
        }
        if (event.getKey() == 32 && event.getAction() == 1) {
            if (player.m_20069_()) {
                return;
            }
            if (!player.m_20096_() && player.m_20184_().f_82480_ < 0.0 && !this.isDiving && !this.isCannonballing) {
                if (this.fallDistance >= 6.0f) {
                    this.playAnimation(player, CANNONBALL_ANIMATION_ID);
                    this.isCannonballing = true;
                } else if (this.fallDistance >= 0.3f) {
                    this.playAnimation(player, DIVING_ANIMATION_ID);
                    this.isDiving = true;
                }
            }
        }
    }

    private void applyFallSlowdown(LocalPlayer player, JumpAnimationConfig config) {
        if (this.highFallSlowdownTicks > 0) {
            --this.highFallSlowdownTicks;
            if (config.highfallSpeedPenalty) {
                this.modifyPlayerSpeed(player, config.highFallSpeedMultiplier);
            }
        } else if (this.fallSlowdownTicks > 0) {
            --this.fallSlowdownTicks;
            if (config.fallSpeedPenalty) {
                this.modifyPlayerSpeed(player, config.fallSpeedMultiplier);
            }
        } else if (this.haystackSlowdownTicks > 0) {
            --this.haystackSlowdownTicks;
            if (config.hayBlockSpeedPenalty) {
                player.m_20256_(Vec3.f_82478_);
                player.f_108618_.f_108567_ = 0.0f;
                player.f_108618_.f_108566_ = 0.0f;
                player.f_108618_.f_108572_ = false;
                player.f_108618_.f_108573_ = false;
                player.f_108618_.f_108568_ = false;
                player.f_108618_.f_108569_ = false;
                player.f_108618_.f_108570_ = false;
                player.f_108618_.f_108571_ = false;
            }
        }
    }

    private void modifyPlayerSpeed(LocalPlayer player, double multiplier) {
        Vec3 movement = player.m_20184_();
        player.m_20334_(movement.f_82479_ * multiplier, movement.f_82480_, movement.f_82481_ * multiplier);
    }

    private void playNextStoppedJumpAnimation(LocalPlayer player) {
        JumpAnimationConfig config = JumpAnimationConfig.getConfig();
        if (!config.enableStoppedJumpAnimations) {
            return;
        }
        ResourceLocation nextAnimationId = this.playJumpNext ? STOPPED_JUMP_ANIMATION_ID : STOPPED_JUMPFLIP_ANIMATION_ID;
        this.playAnimation(player, nextAnimationId);
        this.playJumpNext = !this.playJumpNext;
    }

    private void playNextRunningJumpAnimation(LocalPlayer player, boolean isRunning) {
        JumpAnimationConfig config = JumpAnimationConfig.getConfig();
        if (!config.enableRunningJumpAnimations) {
            return;
        }
        ResourceLocation nextAnimationId = this.playJumpNext ? (isRunning ? RUNNING_JUMP_ANIMATION_ID : JUMP_ANIMATION_ID) : (isRunning ? RUNNING_JUMPFLIP_ANIMATION_ID : JUMPFLIP_ANIMATION_ID);
        this.playAnimation(player, nextAnimationId);
        this.playJumpNext = !this.playJumpNext;
    }

    private void playFallAnimation(LocalPlayer player, ResourceLocation animationId) {
        this.playAnimation(player, animationId);
    }

    private void playAnimation(LocalPlayer player, ResourceLocation animationId) {
        if (this.haystackSlowdownTicks > 0) {
            return;
        }
        JumpAnimationConfig config = JumpAnimationConfig.getConfig();
        if (!this.isAnimationEnabled(animationId, config)) {
            return;
        }
        AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((AbstractClientPlayer)player);
        if (animationStack == null) {
            return;
        }
        KeyframeAnimation animationData = PlayerAnimationRegistry.getAnimation((ResourceLocation)animationId);
        if (animationData == null) {
            return;
        }
        this.stopCurrentAnimation(player);
        KeyframeAnimationPlayer animationPlayer = new KeyframeAnimationPlayer(animationData);
        animationStack.addAnimLayer(0, (IAnimation)animationPlayer);
        JumpAnimationNetworking.CHANNEL.sendToServer((Object)new JumpAnimationNetworking.StartJumpPacket(player.m_20148_().toString(), animationId));
    }

    private void stopCurrentAnimation(LocalPlayer player) {
        AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((AbstractClientPlayer)player);
        if (animationStack != null) {
            animationStack.removeLayer(0);
        }
    }

    private boolean isAnimationEnabled(ResourceLocation animationId, JumpAnimationConfig config) {
        if (animationId.equals((Object)STOPPED_JUMP_ANIMATION_ID) || animationId.equals((Object)STOPPED_JUMPFLIP_ANIMATION_ID)) {
            return config.enableStoppedJumpAnimations;
        }
        if (animationId.equals((Object)RUNNING_JUMP_ANIMATION_ID) || animationId.equals((Object)RUNNING_JUMPFLIP_ANIMATION_ID) || animationId.equals((Object)JUMP_ANIMATION_ID) || animationId.equals((Object)JUMPFLIP_ANIMATION_ID)) {
            return config.enableRunningJumpAnimations;
        }
        if (animationId.equals((Object)DIVING_ANIMATION_ID)) {
            return config.enableDivingAnimation;
        }
        if (animationId.equals((Object)CANNONBALL_ANIMATION_ID)) {
            return config.enableCannonballAnimation;
        }
        if (animationId.equals((Object)ROLL_ANIMATION_ID)) {
            return config.enableRollAnimation;
        }
        if (animationId.equals((Object)SWIMUP_ANIMATION_ID)) {
            return config.enableSwimUpAnimation;
        }
        if (animationId.equals((Object)DIVING_CANNONBALL_ANIMATION_ID)) {
            return config.enableDivingCannonballAnimation;
        }
        if (animationId.equals((Object)HAYSTACK_LANDING_ANIMATION_ID)) {
            return config.enableHaystackLandingAnimation;
        }
        if (animationId.equals((Object)FALL_ANIMATION_ID)) {
            return config.enableFallAnimation;
        }
        if (animationId.equals((Object)HIGHFALL_ANIMATION_ID)) {
            return config.enableHighfallAnimation;
        }
        if (animationId.equals((Object)FALLING_ANIMATION_ID)) {
            return config.enableFallingAnimation;
        }
        return true;
    }

    private boolean isPlayerRunning(LocalPlayer player) {
        double horizontalSpeed = player.m_20184_().m_165925_();
        return player.m_20142_();
    }

    private boolean isPlayerStopped(LocalPlayer player) {
        boolean isMovingHorizontally = player.m_20184_().m_165925_() > 0.0025;
        return !this.isPlayerRunning(player) && !isMovingHorizontally;
    }

    private boolean isOnHaystack(LocalPlayer player) {
        BlockPos posBelow = player.m_20183_().m_7495_();
        BlockState stateBelow = player.f_19853_.m_8055_(posBelow);
        return stateBelow.m_60734_() == Blocks.f_50335_;
    }

    private boolean isPlayerInSurvival(LocalPlayer player) {
        return Minecraft.m_91087_().f_91072_.m_105295_() == GameType.SURVIVAL;
    }
}

