/*
 * Decompiled with CFR 0.152.
 */
package com.saltywater.jumpanimation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraftforge.fml.loading.FMLPaths;

public class JumpAnimationConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE_PATH = FMLPaths.CONFIGDIR.get().resolve("JumpAnimationConfig.json").toString();
    public boolean fallSpeedPenalty = true;
    public boolean highfallSpeedPenalty = true;
    public boolean hayBlockSpeedPenalty = true;
    public boolean noFallDamageOnHay = true;
    public boolean enableStoppedJumpAnimations = true;
    public boolean enableRunningJumpAnimations = true;
    public boolean enableDivingAnimation = true;
    public boolean enableCannonballAnimation = true;
    public boolean enableRollAnimation = true;
    public boolean enableSwimUpAnimation = true;
    public boolean enableDivingCannonballAnimation = true;
    public boolean enableHaystackLandingAnimation = true;
    public boolean enableFallAnimation = true;
    public boolean enableHighfallAnimation = true;
    public boolean enableFallingAnimation = true;
    public int fallSlowdownDurationTicks = 10;
    public int highFallSlowdownDurationTicks = 20;
    public int haystackSlowdownDurationTicks = 60;
    public double fallSpeedMultiplier = 0.8;
    public double highFallSpeedMultiplier = 0.6;
    private static JumpAnimationConfig instance;

    public static JumpAnimationConfig getConfig() {
        if (instance == null) {
            instance = new JumpAnimationConfig();
            instance.loadConfig();
        }
        return instance;
    }

    private void loadConfig() {
        File configFile = new File(CONFIG_FILE_PATH);
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                JumpAnimationConfig loadedConfig = (JumpAnimationConfig)GSON.fromJson((Reader)reader, JumpAnimationConfig.class);
                if (loadedConfig != null) {
                    this.fallSpeedPenalty = loadedConfig.fallSpeedPenalty;
                    this.highfallSpeedPenalty = loadedConfig.highfallSpeedPenalty;
                    this.hayBlockSpeedPenalty = loadedConfig.hayBlockSpeedPenalty;
                    this.noFallDamageOnHay = loadedConfig.noFallDamageOnHay;
                    this.enableStoppedJumpAnimations = loadedConfig.enableStoppedJumpAnimations;
                    this.enableRunningJumpAnimations = loadedConfig.enableRunningJumpAnimations;
                    this.enableDivingAnimation = loadedConfig.enableDivingAnimation;
                    this.enableCannonballAnimation = loadedConfig.enableCannonballAnimation;
                    this.enableRollAnimation = loadedConfig.enableRollAnimation;
                    this.enableSwimUpAnimation = loadedConfig.enableSwimUpAnimation;
                    this.enableDivingCannonballAnimation = loadedConfig.enableDivingCannonballAnimation;
                    this.enableHaystackLandingAnimation = loadedConfig.enableHaystackLandingAnimation;
                    this.enableFallAnimation = loadedConfig.enableFallAnimation;
                    this.enableHighfallAnimation = loadedConfig.enableHighfallAnimation;
                    this.enableFallingAnimation = loadedConfig.enableFallingAnimation;
                    this.fallSlowdownDurationTicks = loadedConfig.fallSlowdownDurationTicks;
                    this.highFallSlowdownDurationTicks = loadedConfig.highFallSlowdownDurationTicks;
                    this.haystackSlowdownDurationTicks = loadedConfig.haystackSlowdownDurationTicks;
                    this.fallSpeedMultiplier = loadedConfig.fallSpeedMultiplier;
                    this.highFallSpeedMultiplier = loadedConfig.highFallSpeedMultiplier;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.saveConfig();
        }
    }

    public void saveConfig() {
        File configFile = new File(CONFIG_FILE_PATH);
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

