/*
 * Decompiled with CFR 0.152.
 */
package com.saltywater.jumpanimation.networking;

import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class JumpAnimationNetworking {
    private static final String PROTOCOL_VERSION = "1.0";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("jumpanimation", "network"), () -> "1.0", "1.0"::equals, "1.0"::equals);

    public static void register() {
        CHANNEL.registerMessage(0, StartJumpPacket.class, StartJumpPacket::encode, StartJumpPacket::decode, StartJumpPacket::handle);
        CHANNEL.registerMessage(1, StopJumpPacket.class, StopJumpPacket::encode, StopJumpPacket::decode, StopJumpPacket::handle);
    }

    public static class StartJumpPacket {
        private final String playerId;
        private final ResourceLocation animationId;

        public StartJumpPacket(String playerId, ResourceLocation animationId) {
            this.playerId = playerId;
            this.animationId = animationId;
        }

        public static void encode(StartJumpPacket packet, FriendlyByteBuf buf) {
            buf.m_130070_(packet.playerId);
            buf.m_130070_(packet.animationId.toString());
        }

        public static StartJumpPacket decode(FriendlyByteBuf buf) {
            String playerId = buf.m_130277_();
            ResourceLocation animId = new ResourceLocation(buf.m_130277_());
            return new StartJumpPacket(playerId, animId);
        }

        public static void handle(StartJumpPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
            NetworkEvent.Context ctx = ctxSupplier.get();
            if (ctx.getDirection().getReceptionSide().isServer()) {
                CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
            } else {
                ctx.enqueueWork(() -> {
                    Minecraft minecraft = Minecraft.m_91087_();
                    minecraft.f_91073_.m_6907_().stream().filter(player -> player.m_20148_().toString().equals(packet.playerId) && player instanceof AbstractClientPlayer).findFirst().ifPresent(player -> {
                        KeyframeAnimation animationData;
                        AnimationStack stack = PlayerAnimationAccess.getPlayerAnimLayer((AbstractClientPlayer)player);
                        if (stack != null && (animationData = PlayerAnimationRegistry.getAnimation((ResourceLocation)packet.animationId)) != null) {
                            stack.addAnimLayer(0, (IAnimation)new KeyframeAnimationPlayer(animationData));
                        }
                    });
                });
            }
            ctx.setPacketHandled(true);
        }
    }

    public static class StopJumpPacket {
        private final String playerId;

        public StopJumpPacket(String playerId) {
            this.playerId = playerId;
        }

        public static void encode(StopJumpPacket packet, FriendlyByteBuf buf) {
            buf.m_130070_(packet.playerId);
        }

        public static StopJumpPacket decode(FriendlyByteBuf buf) {
            return new StopJumpPacket(buf.m_130277_());
        }

        public static void handle(StopJumpPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
            NetworkEvent.Context ctx = ctxSupplier.get();
            if (ctx.getDirection().getReceptionSide().isServer()) {
                CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
            } else {
                ctx.enqueueWork(() -> {
                    Minecraft minecraft = Minecraft.m_91087_();
                    minecraft.f_91073_.m_6907_().stream().filter(player -> player.m_20148_().toString().equals(packet.playerId) && player instanceof AbstractClientPlayer).findFirst().ifPresent(player -> {
                        AnimationStack stack = PlayerAnimationAccess.getPlayerAnimLayer((AbstractClientPlayer)player);
                        if (stack != null) {
                            stack.removeLayer(0);
                        }
                    });
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

