/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.pet_cemetery.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.pet_cemetery.client.renderer.entity.UndeadParrotRenderer;
import com.teamabnormals.pet_cemetery.core.registry.PCEntityTypes;
import net.minecraft.client.model.ParrotModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class UndeadParrotOnShoulderLayer<T extends Player>
extends RenderLayer<T, PlayerModel<T>> {
    private final ParrotModel parrotModel;

    public UndeadParrotOnShoulderLayer(RenderLayerParent<T, PlayerModel<T>> rendererIn, EntityModelSet modelSet) {
        super(rendererIn);
        this.parrotModel = new ParrotModel(modelSet.bakeLayer(ModelLayers.PARROT));
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.renderParrot(matrixStackIn, bufferIn, packedLightIn, entity, limbSwing, limbSwingAmount, netHeadYaw, headPitch, true);
        this.renderParrot(matrixStackIn, bufferIn, packedLightIn, entity, limbSwing, limbSwingAmount, netHeadYaw, headPitch, false);
    }

    private void renderParrot(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float netHeadYaw, float headPitch, boolean leftShoulderIn) {
        CompoundTag nbt = leftShoulderIn ? entity.getShoulderEntityLeft() : entity.getShoulderEntityRight();
        EntityType.byString((String)nbt.getString("id")).filter(type -> type == PCEntityTypes.ZOMBIE_PARROT.get() || type == PCEntityTypes.SKELETON_PARROT.get()).ifPresent(type -> {
            matrixStackIn.pushPose();
            matrixStackIn.translate(leftShoulderIn ? (double)0.4f : (double)-0.4f, entity.isCrouching() ? (double)-1.3f : -1.5, 0.0);
            VertexConsumer vertexConsumer = bufferIn.getBuffer(this.parrotModel.renderType(type == PCEntityTypes.ZOMBIE_PARROT.get() ? UndeadParrotRenderer.ZOMBIE_PARROT_TEXTURE : UndeadParrotRenderer.SKELETON_PARROT_TEXTURE));
            this.parrotModel.renderOnShoulder(matrixStackIn, vertexConsumer, packedLightIn, OverlayTexture.NO_OVERLAY, limbSwing, limbSwingAmount, netHeadYaw, headPitch, entity.tickCount);
            matrixStackIn.popPose();
        });
    }
}

