/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.pet_cemetery.common.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.pet_cemetery.core.other.PCCriteriaTriggers;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.storage.loot.LootContext;

public class ConvertedMobTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, LivingEntity originalEntity, LivingEntity convertedEntity) {
        this.trigger(player, instance -> instance.matches(EntityPredicate.createContext((ServerPlayer)player, (Entity)originalEntity), EntityPredicate.createContext((ServerPlayer)player, (Entity)convertedEntity)));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> originalEntity, Optional<ContextAwarePredicate> convertedEntity) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("original_entity").forGetter(TriggerInstance::originalEntity), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("converted_entity").forGetter(TriggerInstance::convertedEntity)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<TriggerInstance> curedZombiePet() {
            return ((ConvertedMobTrigger)((Object)PCCriteriaTriggers.CURED_ZOMBIE_PET.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.empty(), Optional.empty()));
        }

        public static Criterion<TriggerInstance> respawnedPet(Optional<ContextAwarePredicate> predicate) {
            return ((ConvertedMobTrigger)((Object)PCCriteriaTriggers.RESPAWNED_PET.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.empty(), predicate));
        }

        public static Criterion<TriggerInstance> respawnedPet() {
            return TriggerInstance.respawnedPet(Optional.empty());
        }

        public boolean matches(LootContext mob, LootContext convertedMob) {
            return !(!this.originalEntity.isEmpty() && !this.originalEntity.get().matches(mob) || !this.convertedEntity.isEmpty() && !this.convertedEntity.get().matches(convertedMob));
        }

        public void validate(CriterionValidator validator) {
            super.validate(validator);
            validator.validateEntity(this.originalEntity, ".original_entity");
            validator.validateEntity(this.convertedEntity, ".converted_entity");
        }
    }
}

